/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controltower.model.ControlOperationSummary;
import software.amazon.awssdk.services.controltower.model.ControlOperationsCopier;
import software.amazon.awssdk.services.controltower.model.ControlTowerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListControlOperationsResponse
extends ControlTowerResponse
implements ToCopyableBuilder<Builder, ListControlOperationsResponse> {
    private static final SdkField<List<ControlOperationSummary>> CONTROL_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("controlOperations").getter(ListControlOperationsResponse.getter(ListControlOperationsResponse::controlOperations)).setter(ListControlOperationsResponse.setter(Builder::controlOperations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("controlOperations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlOperationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListControlOperationsResponse.getter(ListControlOperationsResponse::nextToken)).setter(ListControlOperationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTROL_OPERATIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ControlOperationSummary> controlOperations;
    private final String nextToken;

    private ListControlOperationsResponse(BuilderImpl builder) {
        super(builder);
        this.controlOperations = builder.controlOperations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasControlOperations() {
        return this.controlOperations != null && !(this.controlOperations instanceof SdkAutoConstructList);
    }

    public final List<ControlOperationSummary> controlOperations() {
        return this.controlOperations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasControlOperations() ? this.controlOperations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListControlOperationsResponse)) {
            return false;
        }
        ListControlOperationsResponse other = (ListControlOperationsResponse)((Object)obj);
        return this.hasControlOperations() == other.hasControlOperations() && Objects.equals(this.controlOperations(), other.controlOperations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListControlOperationsResponse").add("ControlOperations", this.hasControlOperations() ? this.controlOperations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "controlOperations": {
                return Optional.ofNullable(clazz.cast(this.controlOperations()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListControlOperationsResponse, T> g) {
        return obj -> g.apply((ListControlOperationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerResponse.BuilderImpl
    implements Builder {
        private List<ControlOperationSummary> controlOperations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListControlOperationsResponse model) {
            super(model);
            this.controlOperations(model.controlOperations);
            this.nextToken(model.nextToken);
        }

        public final List<ControlOperationSummary.Builder> getControlOperations() {
            List<ControlOperationSummary.Builder> result = ControlOperationsCopier.copyToBuilder(this.controlOperations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setControlOperations(Collection<ControlOperationSummary.BuilderImpl> controlOperations) {
            this.controlOperations = ControlOperationsCopier.copyFromBuilder(controlOperations);
        }

        @Override
        public final Builder controlOperations(Collection<ControlOperationSummary> controlOperations) {
            this.controlOperations = ControlOperationsCopier.copy(controlOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperations(ControlOperationSummary ... controlOperations) {
            this.controlOperations(Arrays.asList(controlOperations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder controlOperations(Consumer<ControlOperationSummary.Builder> ... controlOperations) {
            this.controlOperations(Stream.of(controlOperations).map(c -> (ControlOperationSummary)((ControlOperationSummary.Builder)ControlOperationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListControlOperationsResponse build() {
            return new ListControlOperationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ControlTowerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListControlOperationsResponse> {
        public Builder controlOperations(Collection<ControlOperationSummary> var1);

        public Builder controlOperations(ControlOperationSummary ... var1);

        public Builder controlOperations(Consumer<ControlOperationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

