/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.LandingZoneOperationSummary;
import software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsRequest;
import software.amazon.awssdk.services.controltower.model.ListLandingZoneOperationsResponse;

public class ListLandingZoneOperationsIterable
implements SdkIterable<ListLandingZoneOperationsResponse> {
    private final ControlTowerClient client;
    private final ListLandingZoneOperationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLandingZoneOperationsIterable(ControlTowerClient client, ListLandingZoneOperationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLandingZoneOperationsResponseFetcher();
    }

    public Iterator<ListLandingZoneOperationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LandingZoneOperationSummary> landingZoneOperations() {
        Function<ListLandingZoneOperationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.landingZoneOperations() != null) {
                return response.landingZoneOperations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLandingZoneOperationsResponseFetcher
    implements SyncPageFetcher<ListLandingZoneOperationsResponse> {
        private ListLandingZoneOperationsResponseFetcher() {
        }

        public boolean hasNextPage(ListLandingZoneOperationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLandingZoneOperationsResponse nextPage(ListLandingZoneOperationsResponse previousPage) {
            if (previousPage == null) {
                return ListLandingZoneOperationsIterable.this.client.listLandingZoneOperations(ListLandingZoneOperationsIterable.this.firstRequest);
            }
            return ListLandingZoneOperationsIterable.this.client.listLandingZoneOperations((ListLandingZoneOperationsRequest)((Object)ListLandingZoneOperationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

