/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.internal.UserAgentUtils;
import software.amazon.awssdk.services.controltower.model.EnabledControlSummary;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse;

public class ListEnabledControlsPublisher
implements SdkPublisher<ListEnabledControlsResponse> {
    private final ControlTowerAsyncClient client;
    private final ListEnabledControlsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnabledControlsPublisher(ControlTowerAsyncClient client, ListEnabledControlsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnabledControlsPublisher(ControlTowerAsyncClient client, ListEnabledControlsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnabledControlsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnabledControlsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnabledControlSummary> enabledControls() {
        Function<ListEnabledControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.enabledControls() != null) {
                return response.enabledControls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnabledControlsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnabledControlsResponseFetcher
    implements AsyncPageFetcher<ListEnabledControlsResponse> {
        private ListEnabledControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnabledControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnabledControlsResponse> nextPage(ListEnabledControlsResponse previousPage) {
            if (previousPage == null) {
                return ListEnabledControlsPublisher.this.client.listEnabledControls(ListEnabledControlsPublisher.this.firstRequest);
            }
            return ListEnabledControlsPublisher.this.client.listEnabledControls((ListEnabledControlsRequest)((Object)ListEnabledControlsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

