/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.controltower.model.ControlTowerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateLandingZoneResponse
extends ControlTowerResponse
implements ToCopyableBuilder<Builder, CreateLandingZoneResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(CreateLandingZoneResponse.getter(CreateLandingZoneResponse::arn)).setter(CreateLandingZoneResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> OPERATION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationIdentifier").getter(CreateLandingZoneResponse.getter(CreateLandingZoneResponse::operationIdentifier)).setter(CreateLandingZoneResponse.setter(Builder::operationIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, OPERATION_IDENTIFIER_FIELD));
    private final String arn;
    private final String operationIdentifier;

    private CreateLandingZoneResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.operationIdentifier = builder.operationIdentifier;
    }

    public final String arn() {
        return this.arn;
    }

    public final String operationIdentifier() {
        return this.operationIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLandingZoneResponse)) {
            return false;
        }
        CreateLandingZoneResponse other = (CreateLandingZoneResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.operationIdentifier(), other.operationIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"CreateLandingZoneResponse").add("Arn", (Object)this.arn()).add("OperationIdentifier", (Object)this.operationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "operationIdentifier": {
                return Optional.ofNullable(clazz.cast(this.operationIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLandingZoneResponse, T> g) {
        return obj -> g.apply((CreateLandingZoneResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ControlTowerResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String operationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLandingZoneResponse model) {
            super(model);
            this.arn(model.arn);
            this.operationIdentifier(model.operationIdentifier);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getOperationIdentifier() {
            return this.operationIdentifier;
        }

        public final void setOperationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
        }

        @Override
        public final Builder operationIdentifier(String operationIdentifier) {
            this.operationIdentifier = operationIdentifier;
            return this;
        }

        @Override
        public CreateLandingZoneResponse build() {
            return new CreateLandingZoneResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ControlTowerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateLandingZoneResponse> {
        public Builder arn(String var1);

        public Builder operationIdentifier(String var1);
    }
}

