/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controltower.ControlTowerClient;
import software.amazon.awssdk.services.controltower.model.EnabledControlSummary;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsRequest;
import software.amazon.awssdk.services.controltower.model.ListEnabledControlsResponse;

public class ListEnabledControlsIterable
implements SdkIterable<ListEnabledControlsResponse> {
    private final ControlTowerClient client;
    private final ListEnabledControlsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnabledControlsIterable(ControlTowerClient client, ListEnabledControlsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEnabledControlsResponseFetcher();
    }

    public Iterator<ListEnabledControlsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnabledControlSummary> enabledControls() {
        Function<ListEnabledControlsResponse, Iterator> getIterator = response -> {
            if (response != null && response.enabledControls() != null) {
                return response.enabledControls().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnabledControlsResponseFetcher
    implements SyncPageFetcher<ListEnabledControlsResponse> {
        private ListEnabledControlsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnabledControlsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnabledControlsResponse nextPage(ListEnabledControlsResponse previousPage) {
            if (previousPage == null) {
                return ListEnabledControlsIterable.this.client.listEnabledControls(ListEnabledControlsIterable.this.firstRequest);
            }
            return ListEnabledControlsIterable.this.client.listEnabledControls((ListEnabledControlsRequest)((Object)ListEnabledControlsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

