/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controltower;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.ControlTowerAsyncClientBuilder;
import software.amazon.awssdk.services.controltower.ControlTowerServiceClientConfiguration;
import software.amazon.awssdk.services.controltower.DefaultControlTowerAsyncClient;
import software.amazon.awssdk.services.controltower.DefaultControlTowerBaseClientBuilder;
import software.amazon.awssdk.services.controltower.endpoints.ControlTowerEndpointProvider;

@SdkInternalApi
final class DefaultControlTowerAsyncClientBuilder
extends DefaultControlTowerBaseClientBuilder<ControlTowerAsyncClientBuilder, ControlTowerAsyncClient>
implements ControlTowerAsyncClientBuilder {
    DefaultControlTowerAsyncClientBuilder() {
    }

    @Override
    public DefaultControlTowerAsyncClientBuilder endpointProvider(ControlTowerEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ControlTowerAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultControlTowerAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        ControlTowerServiceClientConfiguration serviceClientConfiguration = ControlTowerServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultControlTowerAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

