/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogAsyncClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.ControlMapping;
import software.amazon.awssdk.services.controlcatalog.model.ListControlMappingsRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListControlMappingsResponse;

public class ListControlMappingsPublisher
implements SdkPublisher<ListControlMappingsResponse> {
    private final ControlCatalogAsyncClient client;
    private final ListControlMappingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListControlMappingsPublisher(ControlCatalogAsyncClient client, ListControlMappingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListControlMappingsPublisher(ControlCatalogAsyncClient client, ListControlMappingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListControlMappingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListControlMappingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ControlMapping> controlMappings() {
        Function<ListControlMappingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.controlMappings() != null) {
                return response.controlMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListControlMappingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListControlMappingsResponseFetcher
    implements AsyncPageFetcher<ListControlMappingsResponse> {
        private ListControlMappingsResponseFetcher() {
        }

        public boolean hasNextPage(ListControlMappingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListControlMappingsResponse> nextPage(ListControlMappingsResponse previousPage) {
            if (previousPage == null) {
                return ListControlMappingsPublisher.this.client.listControlMappings(ListControlMappingsPublisher.this.firstRequest);
            }
            return ListControlMappingsPublisher.this.client.listControlMappings((ListControlMappingsRequest)((Object)ListControlMappingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

