/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.ObjectiveResourceFilter;
import software.amazon.awssdk.services.controlcatalog.model.ObjectiveResourceFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommonControlFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommonControlFilter> {
    private static final SdkField<List<ObjectiveResourceFilter>> OBJECTIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Objectives").getter(CommonControlFilter.getter(CommonControlFilter::objectives)).setter(CommonControlFilter.setter(Builder::objectives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objectives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectiveResourceFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTIVES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommonControlFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ObjectiveResourceFilter> objectives;

    private CommonControlFilter(BuilderImpl builder) {
        this.objectives = builder.objectives;
    }

    public final boolean hasObjectives() {
        return this.objectives != null && !(this.objectives instanceof SdkAutoConstructList);
    }

    public final List<ObjectiveResourceFilter> objectives() {
        return this.objectives;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectives() ? this.objectives() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommonControlFilter)) {
            return false;
        }
        CommonControlFilter other = (CommonControlFilter)obj;
        return this.hasObjectives() == other.hasObjectives() && Objects.equals(this.objectives(), other.objectives());
    }

    public final String toString() {
        return ToString.builder((String)"CommonControlFilter").add("Objectives", this.hasObjectives() ? this.objectives() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Objectives": {
                return Optional.ofNullable(clazz.cast(this.objectives()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<ObjectiveResourceFilter>>> map = new HashMap<String, SdkField<List<ObjectiveResourceFilter>>>();
        map.put("Objectives", OBJECTIVES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommonControlFilter, T> g) {
        return obj -> g.apply((CommonControlFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ObjectiveResourceFilter> objectives = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CommonControlFilter model) {
            this.objectives(model.objectives);
        }

        public final List<ObjectiveResourceFilter.Builder> getObjectives() {
            List<ObjectiveResourceFilter.Builder> result = ObjectiveResourceFilterListCopier.copyToBuilder(this.objectives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectives(Collection<ObjectiveResourceFilter.BuilderImpl> objectives) {
            this.objectives = ObjectiveResourceFilterListCopier.copyFromBuilder(objectives);
        }

        @Override
        public final Builder objectives(Collection<ObjectiveResourceFilter> objectives) {
            this.objectives = ObjectiveResourceFilterListCopier.copy(objectives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectives(ObjectiveResourceFilter ... objectives) {
            this.objectives(Arrays.asList(objectives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectives(Consumer<ObjectiveResourceFilter.Builder> ... objectives) {
            this.objectives(Stream.of(objectives).map(c -> (ObjectiveResourceFilter)((ObjectiveResourceFilter.Builder)ObjectiveResourceFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CommonControlFilter build() {
            return new CommonControlFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommonControlFilter> {
        public Builder objectives(Collection<ObjectiveResourceFilter> var1);

        public Builder objectives(ObjectiveResourceFilter ... var1);

        public Builder objectives(Consumer<ObjectiveResourceFilter.Builder> ... var1);
    }
}

