/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.controlcatalog.model.ControlScope;
import software.amazon.awssdk.services.controlcatalog.model.DeployableRegionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RegionConfiguration> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scope").getter(RegionConfiguration.getter(RegionConfiguration::scopeAsString)).setter(RegionConfiguration.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<List<String>> DEPLOYABLE_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeployableRegions").getter(RegionConfiguration.getter(RegionConfiguration::deployableRegions)).setter(RegionConfiguration.setter(Builder::deployableRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployableRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, DEPLOYABLE_REGIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegionConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scope;
    private final List<String> deployableRegions;

    private RegionConfiguration(BuilderImpl builder) {
        this.scope = builder.scope;
        this.deployableRegions = builder.deployableRegions;
    }

    public final ControlScope scope() {
        return ControlScope.fromValue(this.scope);
    }

    public final String scopeAsString() {
        return this.scope;
    }

    public final boolean hasDeployableRegions() {
        return this.deployableRegions != null && !(this.deployableRegions instanceof SdkAutoConstructList);
    }

    public final List<String> deployableRegions() {
        return this.deployableRegions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeployableRegions() ? this.deployableRegions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionConfiguration)) {
            return false;
        }
        RegionConfiguration other = (RegionConfiguration)obj;
        return Objects.equals(this.scopeAsString(), other.scopeAsString()) && this.hasDeployableRegions() == other.hasDeployableRegions() && Objects.equals(this.deployableRegions(), other.deployableRegions());
    }

    public final String toString() {
        return ToString.builder((String)"RegionConfiguration").add("Scope", (Object)this.scopeAsString()).add("DeployableRegions", this.hasDeployableRegions() ? this.deployableRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "DeployableRegions": {
                return Optional.ofNullable(clazz.cast(this.deployableRegions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Scope", SCOPE_FIELD);
        map.put("DeployableRegions", DEPLOYABLE_REGIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionConfiguration, T> g) {
        return obj -> g.apply((RegionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scope;
        private List<String> deployableRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegionConfiguration model) {
            this.scope(model.scope);
            this.deployableRegions(model.deployableRegions);
        }

        public final String getScope() {
            return this.scope;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(ControlScope scope) {
            this.scope(scope == null ? null : scope.toString());
            return this;
        }

        public final Collection<String> getDeployableRegions() {
            if (this.deployableRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deployableRegions;
        }

        public final void setDeployableRegions(Collection<String> deployableRegions) {
            this.deployableRegions = DeployableRegionsCopier.copy(deployableRegions);
        }

        @Override
        public final Builder deployableRegions(Collection<String> deployableRegions) {
            this.deployableRegions = DeployableRegionsCopier.copy(deployableRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployableRegions(String ... deployableRegions) {
            this.deployableRegions(Arrays.asList(deployableRegions));
            return this;
        }

        public RegionConfiguration build() {
            return new RegionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RegionConfiguration> {
        public Builder scope(String var1);

        public Builder scope(ControlScope var1);

        public Builder deployableRegions(Collection<String> var1);

        public Builder deployableRegions(String ... var1);
    }
}

