/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ControlScope {
    GLOBAL("GLOBAL"),
    REGIONAL("REGIONAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ControlScope> VALUE_MAP;
    private final String value;

    private ControlScope(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ControlScope fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ControlScope> knownValues() {
        EnumSet<ControlScope> knownValues = EnumSet.allOf(ControlScope.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ControlScope.class, ControlScope::toString);
    }
}

