/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.controlcatalog.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.controlcatalog.ControlCatalogAsyncClient;
import software.amazon.awssdk.services.controlcatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.controlcatalog.model.ListObjectivesRequest;
import software.amazon.awssdk.services.controlcatalog.model.ListObjectivesResponse;
import software.amazon.awssdk.services.controlcatalog.model.ObjectiveSummary;

public class ListObjectivesPublisher
implements SdkPublisher<ListObjectivesResponse> {
    private final ControlCatalogAsyncClient client;
    private final ListObjectivesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListObjectivesPublisher(ControlCatalogAsyncClient client, ListObjectivesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListObjectivesPublisher(ControlCatalogAsyncClient client, ListObjectivesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListObjectivesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListObjectivesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ObjectiveSummary> objectives() {
        Function<ListObjectivesResponse, Iterator> getIterator = response -> {
            if (response != null && response.objectives() != null) {
                return response.objectives().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListObjectivesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListObjectivesResponseFetcher
    implements AsyncPageFetcher<ListObjectivesResponse> {
        private ListObjectivesResponseFetcher() {
        }

        public boolean hasNextPage(ListObjectivesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListObjectivesResponse> nextPage(ListObjectivesResponse previousPage) {
            if (previousPage == null) {
                return ListObjectivesPublisher.this.client.listObjectives(ListObjectivesPublisher.this.firstRequest);
            }
            return ListObjectivesPublisher.this.client.listObjectives((ListObjectivesRequest)((Object)ListObjectivesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

