/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectparticipant.model.AttachmentIdListCopier;
import software.amazon.awssdk.services.connectparticipant.model.ConnectParticipantRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteAttachmentUploadRequest
extends ConnectParticipantRequest
implements ToCopyableBuilder<Builder, CompleteAttachmentUploadRequest> {
    private static final SdkField<List<String>> ATTACHMENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachmentIds").getter(CompleteAttachmentUploadRequest.getter(CompleteAttachmentUploadRequest::attachmentIds)).setter(CompleteAttachmentUploadRequest.setter(Builder::attachmentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CompleteAttachmentUploadRequest.getter(CompleteAttachmentUploadRequest::clientToken)).setter(CompleteAttachmentUploadRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionToken").getter(CompleteAttachmentUploadRequest.getter(CompleteAttachmentUploadRequest::connectionToken)).setter(CompleteAttachmentUploadRequest.setter(Builder::connectionToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_IDS_FIELD, CLIENT_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompleteAttachmentUploadRequest.memberNameToFieldInitializer();
    private final List<String> attachmentIds;
    private final String clientToken;
    private final String connectionToken;

    private CompleteAttachmentUploadRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentIds = builder.attachmentIds;
        this.clientToken = builder.clientToken;
        this.connectionToken = builder.connectionToken;
    }

    public final boolean hasAttachmentIds() {
        return this.attachmentIds != null && !(this.attachmentIds instanceof SdkAutoConstructList);
    }

    public final List<String> attachmentIds() {
        return this.attachmentIds;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String connectionToken() {
        return this.connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachmentIds() ? this.attachmentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteAttachmentUploadRequest)) {
            return false;
        }
        CompleteAttachmentUploadRequest other = (CompleteAttachmentUploadRequest)((Object)obj);
        return this.hasAttachmentIds() == other.hasAttachmentIds() && Objects.equals(this.attachmentIds(), other.attachmentIds()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.connectionToken(), other.connectionToken());
    }

    public final String toString() {
        return ToString.builder((String)"CompleteAttachmentUploadRequest").add("AttachmentIds", this.hasAttachmentIds() ? this.attachmentIds() : null).add("ClientToken", (Object)this.clientToken()).add("ConnectionToken", (Object)this.connectionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentIds": {
                return Optional.ofNullable(clazz.cast(this.attachmentIds()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ConnectionToken": {
                return Optional.ofNullable(clazz.cast(this.connectionToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AttachmentIds", ATTACHMENT_IDS_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("X-Amz-Bearer", CONNECTION_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompleteAttachmentUploadRequest, T> g) {
        return obj -> g.apply((CompleteAttachmentUploadRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectParticipantRequest.BuilderImpl
    implements Builder {
        private List<String> attachmentIds = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteAttachmentUploadRequest model) {
            super(model);
            this.attachmentIds(model.attachmentIds);
            this.clientToken(model.clientToken);
            this.connectionToken(model.connectionToken);
        }

        public final Collection<String> getAttachmentIds() {
            if (this.attachmentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.attachmentIds;
        }

        public final void setAttachmentIds(Collection<String> attachmentIds) {
            this.attachmentIds = AttachmentIdListCopier.copy(attachmentIds);
        }

        @Override
        public final Builder attachmentIds(Collection<String> attachmentIds) {
            this.attachmentIds = AttachmentIdListCopier.copy(attachmentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentIds(String ... attachmentIds) {
            this.attachmentIds(Arrays.asList(attachmentIds));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConnectionToken() {
            return this.connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CompleteAttachmentUploadRequest build() {
            return new CompleteAttachmentUploadRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectParticipantRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CompleteAttachmentUploadRequest> {
        public Builder attachmentIds(Collection<String> var1);

        public Builder attachmentIds(String ... var1);

        public Builder clientToken(String var1);

        public Builder connectionToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

