/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendEventRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<SendEventRequest.Builder, SendEventRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(SendEventRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(SendEventRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(SendEventRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectionToken").getter(getter(SendEventRequest::connectionToken))
            .setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_FIELD, CLIENT_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));

    private final String contentType;

    private final String content;

    private final String clientToken;

    private final String connectionToken;

    private SendEventRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.content = builder.content;
        this.clientToken = builder.clientToken;
        this.connectionToken = builder.connectionToken;
    }

    /**
     * <p>
     * The content type of the request. Supported types are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * application/vnd.amazonaws.connect.event.typing
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.amazonaws.connect.event.connection.acknowledged
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.amazonaws.connect.event.message.delivered
     * </p>
     * </li>
     * <li>
     * <p>
     * application/vnd.amazonaws.connect.event.message.read
     * </p>
     * </li>
     * </ul>
     * 
     * @return The content type of the request. Supported types are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         application/vnd.amazonaws.connect.event.typing
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.amazonaws.connect.event.connection.acknowledged
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.amazonaws.connect.event.message.delivered
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         application/vnd.amazonaws.connect.event.message.read
     *         </p>
     *         </li>
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The content of the event to be sent (for example, message text). For content related to message receipts, this is
     * supported in the form of a JSON string.
     * </p>
     * <p>
     * Sample Content: "{\"messageId\":\"11111111-aaaa-bbbb-cccc-EXAMPLE01234\"}"
     * </p>
     * 
     * @return The content of the event to be sent (for example, message text). For content related to message receipts,
     *         this is supported in the form of a JSON string.</p>
     *         <p>
     *         Sample Content: "{\"messageId\":\"11111111-aaaa-bbbb-cccc-EXAMPLE01234\"}"
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not provided,
     * the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
     * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe with
     * idempotent APIs</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
     *         provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see
     *         <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
     *         retries safe with idempotent APIs</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The authentication token associated with the participant's connection.
     * </p>
     * 
     * @return The authentication token associated with the participant's connection.
     */
    public final String connectionToken() {
        return connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendEventRequest)) {
            return false;
        }
        SendEventRequest other = (SendEventRequest) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(content(), other.content())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(connectionToken(), other.connectionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SendEventRequest").add("ContentType", contentType()).add("Content", content())
                .add("ClientToken", clientToken()).add("ConnectionToken", connectionToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendEventRequest, T> g) {
        return obj -> g.apply((SendEventRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendEventRequest> {
        /**
         * <p>
         * The content type of the request. Supported types are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * application/vnd.amazonaws.connect.event.typing
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.amazonaws.connect.event.connection.acknowledged
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.amazonaws.connect.event.message.delivered
         * </p>
         * </li>
         * <li>
         * <p>
         * application/vnd.amazonaws.connect.event.message.read
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The content type of the request. Supported types are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        application/vnd.amazonaws.connect.event.typing
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.amazonaws.connect.event.connection.acknowledged
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.amazonaws.connect.event.message.delivered
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        application/vnd.amazonaws.connect.event.message.read
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content of the event to be sent (for example, message text). For content related to message receipts,
         * this is supported in the form of a JSON string.
         * </p>
         * <p>
         * Sample Content: "{\"messageId\":\"11111111-aaaa-bbbb-cccc-EXAMPLE01234\"}"
         * </p>
         * 
         * @param content
         *        The content of the event to be sent (for example, message text). For content related to message
         *        receipts, this is supported in the form of a JSON string.</p>
         *        <p>
         *        Sample Content: "{\"messageId\":\"11111111-aaaa-bbbb-cccc-EXAMPLE01234\"}"
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         * provided, the Amazon Web Services SDK populates this field. For more information about idempotency, see <a
         * href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making retries safe
         * with idempotent APIs</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. If not
         *        provided, the Amazon Web Services SDK populates this field. For more information about idempotency,
         *        see <a href="https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/">Making
         *        retries safe with idempotent APIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The authentication token associated with the participant's connection.
         * </p>
         * 
         * @param connectionToken
         *        The authentication token associated with the participant's connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private String contentType;

        private String content;

        private String clientToken;

        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendEventRequest model) {
            super(model);
            contentType(model.contentType);
            content(model.content);
            clientToken(model.clientToken);
            connectionToken(model.connectionToken);
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendEventRequest build() {
            return new SendEventRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
