/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SendMessageRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<SendMessageRequest.Builder, SendMessageRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendMessageRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendMessageRequest::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SendMessageRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SendMessageRequest::connectionToken)).setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD,
            CONTENT_FIELD, CLIENT_TOKEN_FIELD, CONNECTION_TOKEN_FIELD));

    private final String contentType;

    private final String content;

    private final String clientToken;

    private final String connectionToken;

    private SendMessageRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.content = builder.content;
        this.clientToken = builder.clientToken;
        this.connectionToken = builder.connectionToken;
    }

    /**
     * <p>
     * The type of the content. Supported types are text/plain.
     * </p>
     * 
     * @return The type of the content. Supported types are text/plain.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The content of the message.
     * </p>
     * 
     * @return The content of the message.
     */
    public String content() {
        return content;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The authentication token associated with the connection.
     * </p>
     * 
     * @return The authentication token associated with the connection.
     */
    public String connectionToken() {
        return connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendMessageRequest)) {
            return false;
        }
        SendMessageRequest other = (SendMessageRequest) obj;
        return Objects.equals(contentType(), other.contentType()) && Objects.equals(content(), other.content())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(connectionToken(), other.connectionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SendMessageRequest").add("ContentType", contentType()).add("Content", content())
                .add("ClientToken", clientToken()).add("ConnectionToken", connectionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendMessageRequest, T> g) {
        return obj -> g.apply((SendMessageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo, CopyableBuilder<Builder, SendMessageRequest> {
        /**
         * <p>
         * The type of the content. Supported types are text/plain.
         * </p>
         * 
         * @param contentType
         *        The type of the content. Supported types are text/plain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The content of the message.
         * </p>
         * 
         * @param content
         *        The content of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The authentication token associated with the connection.
         * </p>
         * 
         * @param connectionToken
         *        The authentication token associated with the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private String contentType;

        private String content;

        private String clientToken;

        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SendMessageRequest model) {
            super(model);
            contentType(model.contentType);
            content(model.content);
            clientToken(model.clientToken);
            connectionToken(model.connectionToken);
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SendMessageRequest build() {
            return new SendMessageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
