/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectparticipant.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTranscriptRequest extends ConnectParticipantRequest implements
        ToCopyableBuilder<GetTranscriptRequest.Builder, GetTranscriptRequest> {
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTranscriptRequest::contactId)).setter(setter(Builder::contactId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactId").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetTranscriptRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTranscriptRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SCAN_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTranscriptRequest::scanDirectionAsString)).setter(setter(Builder::scanDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanDirection").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTranscriptRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<StartPosition> START_POSITION_FIELD = SdkField
            .<StartPosition> builder(MarshallingType.SDK_POJO).getter(getter(GetTranscriptRequest::startPosition))
            .setter(setter(Builder::startPosition)).constructor(StartPosition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartPosition").build()).build();

    private static final SdkField<String> CONNECTION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetTranscriptRequest::connectionToken)).setter(setter(Builder::connectionToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Bearer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_ID_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SCAN_DIRECTION_FIELD, SORT_ORDER_FIELD, START_POSITION_FIELD,
            CONNECTION_TOKEN_FIELD));

    private final String contactId;

    private final Integer maxResults;

    private final String nextToken;

    private final String scanDirection;

    private final String sortOrder;

    private final StartPosition startPosition;

    private final String connectionToken;

    private GetTranscriptRequest(BuilderImpl builder) {
        super(builder);
        this.contactId = builder.contactId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.scanDirection = builder.scanDirection;
        this.sortOrder = builder.sortOrder;
        this.startPosition = builder.startPosition;
        this.connectionToken = builder.connectionToken;
    }

    /**
     * <p>
     * The contactId from the current contact chain for which transcript is needed.
     * </p>
     * 
     * @return The contactId from the current contact chain for which transcript is needed.
     */
    public String contactId() {
        return contactId;
    }

    /**
     * <p>
     * The maximum number of results to return in the page. Default: 10.
     * </p>
     * 
     * @return The maximum number of results to return in the page. Default: 10.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The pagination token. Use the value returned previously in the next subsequent request to retrieve the next set
     * of results.
     * </p>
     * 
     * @return The pagination token. Use the value returned previously in the next subsequent request to retrieve the
     *         next set of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition is
     * provided, FORWARD with StartPosition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanDirection}
     * will return {@link ScanDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanDirectionAsString}.
     * </p>
     * 
     * @return The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition
     *         is provided, FORWARD with StartPosition.
     * @see ScanDirection
     */
    public ScanDirection scanDirection() {
        return ScanDirection.fromValue(scanDirection);
    }

    /**
     * <p>
     * The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition is
     * provided, FORWARD with StartPosition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanDirection}
     * will return {@link ScanDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scanDirectionAsString}.
     * </p>
     * 
     * @return The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition
     *         is provided, FORWARD with StartPosition.
     * @see ScanDirection
     */
    public String scanDirectionAsString() {
        return scanDirection;
    }

    /**
     * <p>
     * The sort order for the records. Default: DESCENDING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the records. Default: DESCENDING.
     * @see SortKey
     */
    public SortKey sortOrder() {
        return SortKey.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for the records. Default: DESCENDING.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for the records. Default: DESCENDING.
     * @see SortKey
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * A filtering option for where to start.
     * </p>
     * 
     * @return A filtering option for where to start.
     */
    public StartPosition startPosition() {
        return startPosition;
    }

    /**
     * <p>
     * The authentication token associated with the participant's connection.
     * </p>
     * 
     * @return The authentication token associated with the participant's connection.
     */
    public String connectionToken() {
        return connectionToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contactId());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(scanDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startPosition());
        hashCode = 31 * hashCode + Objects.hashCode(connectionToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTranscriptRequest)) {
            return false;
        }
        GetTranscriptRequest other = (GetTranscriptRequest) obj;
        return Objects.equals(contactId(), other.contactId()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(scanDirectionAsString(), other.scanDirectionAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(startPosition(), other.startPosition())
                && Objects.equals(connectionToken(), other.connectionToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetTranscriptRequest").add("ContactId", contactId()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("ScanDirection", scanDirectionAsString())
                .add("SortOrder", sortOrderAsString()).add("StartPosition", startPosition())
                .add("ConnectionToken", connectionToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContactId":
            return Optional.ofNullable(clazz.cast(contactId()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ScanDirection":
            return Optional.ofNullable(clazz.cast(scanDirectionAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "StartPosition":
            return Optional.ofNullable(clazz.cast(startPosition()));
        case "ConnectionToken":
            return Optional.ofNullable(clazz.cast(connectionToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTranscriptRequest, T> g) {
        return obj -> g.apply((GetTranscriptRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectParticipantRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTranscriptRequest> {
        /**
         * <p>
         * The contactId from the current contact chain for which transcript is needed.
         * </p>
         * 
         * @param contactId
         *        The contactId from the current contact chain for which transcript is needed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactId(String contactId);

        /**
         * <p>
         * The maximum number of results to return in the page. Default: 10.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the page. Default: 10.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The pagination token. Use the value returned previously in the next subsequent request to retrieve the next
         * set of results.
         * </p>
         * 
         * @param nextToken
         *        The pagination token. Use the value returned previously in the next subsequent request to retrieve the
         *        next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition is
         * provided, FORWARD with StartPosition.
         * </p>
         * 
         * @param scanDirection
         *        The direction from StartPosition from which to retrieve message. Default: BACKWARD when no
         *        StartPosition is provided, FORWARD with StartPosition.
         * @see ScanDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanDirection
         */
        Builder scanDirection(String scanDirection);

        /**
         * <p>
         * The direction from StartPosition from which to retrieve message. Default: BACKWARD when no StartPosition is
         * provided, FORWARD with StartPosition.
         * </p>
         * 
         * @param scanDirection
         *        The direction from StartPosition from which to retrieve message. Default: BACKWARD when no
         *        StartPosition is provided, FORWARD with StartPosition.
         * @see ScanDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanDirection
         */
        Builder scanDirection(ScanDirection scanDirection);

        /**
         * <p>
         * The sort order for the records. Default: DESCENDING.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the records. Default: DESCENDING.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for the records. Default: DESCENDING.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for the records. Default: DESCENDING.
         * @see SortKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortKey
         */
        Builder sortOrder(SortKey sortOrder);

        /**
         * <p>
         * A filtering option for where to start.
         * </p>
         * 
         * @param startPosition
         *        A filtering option for where to start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startPosition(StartPosition startPosition);

        /**
         * <p>
         * A filtering option for where to start.
         * </p>
         * This is a convenience that creates an instance of the {@link StartPosition.Builder} avoiding the need to
         * create one manually via {@link StartPosition#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartPosition.Builder#build()} is called immediately and its
         * result is passed to {@link #startPosition(StartPosition)}.
         * 
         * @param startPosition
         *        a consumer that will call methods on {@link StartPosition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startPosition(StartPosition)
         */
        default Builder startPosition(Consumer<StartPosition.Builder> startPosition) {
            return startPosition(StartPosition.builder().applyMutation(startPosition).build());
        }

        /**
         * <p>
         * The authentication token associated with the participant's connection.
         * </p>
         * 
         * @param connectionToken
         *        The authentication token associated with the participant's connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionToken(String connectionToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectParticipantRequest.BuilderImpl implements Builder {
        private String contactId;

        private Integer maxResults;

        private String nextToken;

        private String scanDirection;

        private String sortOrder;

        private StartPosition startPosition;

        private String connectionToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTranscriptRequest model) {
            super(model);
            contactId(model.contactId);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            scanDirection(model.scanDirection);
            sortOrder(model.sortOrder);
            startPosition(model.startPosition);
            connectionToken(model.connectionToken);
        }

        public final String getContactId() {
            return contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getScanDirection() {
            return scanDirection;
        }

        @Override
        public final Builder scanDirection(String scanDirection) {
            this.scanDirection = scanDirection;
            return this;
        }

        @Override
        public final Builder scanDirection(ScanDirection scanDirection) {
            this.scanDirection(scanDirection == null ? null : scanDirection.toString());
            return this;
        }

        public final void setScanDirection(String scanDirection) {
            this.scanDirection = scanDirection;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortKey sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final StartPosition.Builder getStartPosition() {
            return startPosition != null ? startPosition.toBuilder() : null;
        }

        @Override
        public final Builder startPosition(StartPosition startPosition) {
            this.startPosition = startPosition;
            return this;
        }

        public final void setStartPosition(StartPosition.BuilderImpl startPosition) {
            this.startPosition = startPosition != null ? startPosition.build() : null;
        }

        public final String getConnectionToken() {
            return connectionToken;
        }

        @Override
        public final Builder connectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
            return this;
        }

        public final void setConnectionToken(String connectionToken) {
            this.connectionToken = connectionToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTranscriptRequest build() {
            return new GetTranscriptRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
