/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcontactlens.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcontactlens.ConnectContactLensAsyncClient;
import software.amazon.awssdk.services.connectcontactlens.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsRequest;
import software.amazon.awssdk.services.connectcontactlens.model.ListRealtimeContactAnalysisSegmentsResponse;

public class ListRealtimeContactAnalysisSegmentsPublisher
implements SdkPublisher<ListRealtimeContactAnalysisSegmentsResponse> {
    private final ConnectContactLensAsyncClient client;
    private final ListRealtimeContactAnalysisSegmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRealtimeContactAnalysisSegmentsPublisher(ConnectContactLensAsyncClient client, ListRealtimeContactAnalysisSegmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRealtimeContactAnalysisSegmentsPublisher(ConnectContactLensAsyncClient client, ListRealtimeContactAnalysisSegmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRealtimeContactAnalysisSegmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRealtimeContactAnalysisSegmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRealtimeContactAnalysisSegmentsResponseFetcher
    implements AsyncPageFetcher<ListRealtimeContactAnalysisSegmentsResponse> {
        private ListRealtimeContactAnalysisSegmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListRealtimeContactAnalysisSegmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRealtimeContactAnalysisSegmentsResponse> nextPage(ListRealtimeContactAnalysisSegmentsResponse previousPage) {
            if (previousPage == null) {
                return ListRealtimeContactAnalysisSegmentsPublisher.this.client.listRealtimeContactAnalysisSegments(ListRealtimeContactAnalysisSegmentsPublisher.this.firstRequest);
            }
            return ListRealtimeContactAnalysisSegmentsPublisher.this.client.listRealtimeContactAnalysisSegments((ListRealtimeContactAnalysisSegmentsRequest)((Object)ListRealtimeContactAnalysisSegmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

