/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The section of the contact audio where that category rule was detected.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PointOfInterest implements SdkPojo, Serializable, ToCopyableBuilder<PointOfInterest.Builder, PointOfInterest> {
    private static final SdkField<Integer> BEGIN_OFFSET_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BeginOffsetMillis").getter(getter(PointOfInterest::beginOffsetMillis))
            .setter(setter(Builder::beginOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BeginOffsetMillis").build()).build();

    private static final SdkField<Integer> END_OFFSET_MILLIS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EndOffsetMillis").getter(getter(PointOfInterest::endOffsetMillis))
            .setter(setter(Builder::endOffsetMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndOffsetMillis").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEGIN_OFFSET_MILLIS_FIELD,
            END_OFFSET_MILLIS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer beginOffsetMillis;

    private final Integer endOffsetMillis;

    private PointOfInterest(BuilderImpl builder) {
        this.beginOffsetMillis = builder.beginOffsetMillis;
        this.endOffsetMillis = builder.endOffsetMillis;
    }

    /**
     * <p>
     * The beginning offset in milliseconds where the category rule was detected.
     * </p>
     * 
     * @return The beginning offset in milliseconds where the category rule was detected.
     */
    public final Integer beginOffsetMillis() {
        return beginOffsetMillis;
    }

    /**
     * <p>
     * The ending offset in milliseconds where the category rule was detected.
     * </p>
     * 
     * @return The ending offset in milliseconds where the category rule was detected.
     */
    public final Integer endOffsetMillis() {
        return endOffsetMillis;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(beginOffsetMillis());
        hashCode = 31 * hashCode + Objects.hashCode(endOffsetMillis());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PointOfInterest)) {
            return false;
        }
        PointOfInterest other = (PointOfInterest) obj;
        return Objects.equals(beginOffsetMillis(), other.beginOffsetMillis())
                && Objects.equals(endOffsetMillis(), other.endOffsetMillis());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PointOfInterest").add("BeginOffsetMillis", beginOffsetMillis())
                .add("EndOffsetMillis", endOffsetMillis()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BeginOffsetMillis":
            return Optional.ofNullable(clazz.cast(beginOffsetMillis()));
        case "EndOffsetMillis":
            return Optional.ofNullable(clazz.cast(endOffsetMillis()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PointOfInterest, T> g) {
        return obj -> g.apply((PointOfInterest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PointOfInterest> {
        /**
         * <p>
         * The beginning offset in milliseconds where the category rule was detected.
         * </p>
         * 
         * @param beginOffsetMillis
         *        The beginning offset in milliseconds where the category rule was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beginOffsetMillis(Integer beginOffsetMillis);

        /**
         * <p>
         * The ending offset in milliseconds where the category rule was detected.
         * </p>
         * 
         * @param endOffsetMillis
         *        The ending offset in milliseconds where the category rule was detected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endOffsetMillis(Integer endOffsetMillis);
    }

    static final class BuilderImpl implements Builder {
        private Integer beginOffsetMillis;

        private Integer endOffsetMillis;

        private BuilderImpl() {
        }

        private BuilderImpl(PointOfInterest model) {
            beginOffsetMillis(model.beginOffsetMillis);
            endOffsetMillis(model.endOffsetMillis);
        }

        public final Integer getBeginOffsetMillis() {
            return beginOffsetMillis;
        }

        @Override
        public final Builder beginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
            return this;
        }

        public final void setBeginOffsetMillis(Integer beginOffsetMillis) {
            this.beginOffsetMillis = beginOffsetMillis;
        }

        public final Integer getEndOffsetMillis() {
            return endOffsetMillis;
        }

        @Override
        public final Builder endOffsetMillis(Integer endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
            return this;
        }

        public final void setEndOffsetMillis(Integer endOffsetMillis) {
            this.endOffsetMillis = endOffsetMillis;
        }

        @Override
        public PointOfInterest build() {
            return new PointOfInterest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
