/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Potential issues that are detected based on an artificial intelligence analysis of each turn in the conversation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IssueDetected implements SdkPojo, Serializable, ToCopyableBuilder<IssueDetected.Builder, IssueDetected> {
    private static final SdkField<CharacterOffsets> CHARACTER_OFFSETS_FIELD = SdkField
            .<CharacterOffsets> builder(MarshallingType.SDK_POJO).memberName("CharacterOffsets")
            .getter(getter(IssueDetected::characterOffsets)).setter(setter(Builder::characterOffsets))
            .constructor(CharacterOffsets::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterOffsets").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHARACTER_OFFSETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final CharacterOffsets characterOffsets;

    private IssueDetected(BuilderImpl builder) {
        this.characterOffsets = builder.characterOffsets;
    }

    /**
     * <p>
     * The offset for when the issue was detected in the segment.
     * </p>
     * 
     * @return The offset for when the issue was detected in the segment.
     */
    public final CharacterOffsets characterOffsets() {
        return characterOffsets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(characterOffsets());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IssueDetected)) {
            return false;
        }
        IssueDetected other = (IssueDetected) obj;
        return Objects.equals(characterOffsets(), other.characterOffsets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IssueDetected").add("CharacterOffsets", characterOffsets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CharacterOffsets":
            return Optional.ofNullable(clazz.cast(characterOffsets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IssueDetected, T> g) {
        return obj -> g.apply((IssueDetected) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IssueDetected> {
        /**
         * <p>
         * The offset for when the issue was detected in the segment.
         * </p>
         * 
         * @param characterOffsets
         *        The offset for when the issue was detected in the segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterOffsets(CharacterOffsets characterOffsets);

        /**
         * <p>
         * The offset for when the issue was detected in the segment.
         * </p>
         * This is a convenience that creates an instance of the {@link CharacterOffsets.Builder} avoiding the need to
         * create one manually via {@link CharacterOffsets#builder()}.
         *
         * When the {@link Consumer} completes, {@link CharacterOffsets.Builder#build()} is called immediately and its
         * result is passed to {@link #characterOffsets(CharacterOffsets)}.
         * 
         * @param characterOffsets
         *        a consumer that will call methods on {@link CharacterOffsets.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #characterOffsets(CharacterOffsets)
         */
        default Builder characterOffsets(Consumer<CharacterOffsets.Builder> characterOffsets) {
            return characterOffsets(CharacterOffsets.builder().applyMutation(characterOffsets).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CharacterOffsets characterOffsets;

        private BuilderImpl() {
        }

        private BuilderImpl(IssueDetected model) {
            characterOffsets(model.characterOffsets);
        }

        public final CharacterOffsets.Builder getCharacterOffsets() {
            return characterOffsets != null ? characterOffsets.toBuilder() : null;
        }

        @Override
        public final Builder characterOffsets(CharacterOffsets characterOffsets) {
            this.characterOffsets = characterOffsets;
            return this;
        }

        public final void setCharacterOffsets(CharacterOffsets.BuilderImpl characterOffsets) {
            this.characterOffsets = characterOffsets != null ? characterOffsets.build() : null;
        }

        @Override
        public IssueDetected build() {
            return new IssueDetected(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
