/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcontactlens.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the category rules that are used to automatically categorize contacts based on uttered keywords and phrases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Categories implements SdkPojo, Serializable, ToCopyableBuilder<Categories.Builder, Categories> {
    private static final SdkField<List<String>> MATCHED_CATEGORIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchedCategories")
            .getter(getter(Categories::matchedCategories))
            .setter(setter(Builder::matchedCategories))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedCategories").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, CategoryDetails>> MATCHED_DETAILS_FIELD = SdkField
            .<Map<String, CategoryDetails>> builder(MarshallingType.MAP)
            .memberName("MatchedDetails")
            .getter(getter(Categories::matchedDetails))
            .setter(setter(Builder::matchedDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CategoryDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(CategoryDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCHED_CATEGORIES_FIELD,
            MATCHED_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> matchedCategories;

    private final Map<String, CategoryDetails> matchedDetails;

    private Categories(BuilderImpl builder) {
        this.matchedCategories = builder.matchedCategories;
        this.matchedDetails = builder.matchedDetails;
    }

    /**
     * Returns true if the MatchedCategories property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMatchedCategories() {
        return matchedCategories != null && !(matchedCategories instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The category rules that have been matched in the analyzed segment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchedCategories()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The category rules that have been matched in the analyzed segment.
     */
    public final List<String> matchedCategories() {
        return matchedCategories;
    }

    /**
     * Returns true if the MatchedDetails property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMatchedDetails() {
        return matchedDetails != null && !(matchedDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The category rule that was matched and when it occurred in the transcript.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchedDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The category rule that was matched and when it occurred in the transcript.
     */
    public final Map<String, CategoryDetails> matchedDetails() {
        return matchedDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedCategories() ? matchedCategories() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchedDetails() ? matchedDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Categories)) {
            return false;
        }
        Categories other = (Categories) obj;
        return hasMatchedCategories() == other.hasMatchedCategories()
                && Objects.equals(matchedCategories(), other.matchedCategories())
                && hasMatchedDetails() == other.hasMatchedDetails() && Objects.equals(matchedDetails(), other.matchedDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Categories").add("MatchedCategories", hasMatchedCategories() ? matchedCategories() : null)
                .add("MatchedDetails", hasMatchedDetails() ? matchedDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchedCategories":
            return Optional.ofNullable(clazz.cast(matchedCategories()));
        case "MatchedDetails":
            return Optional.ofNullable(clazz.cast(matchedDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Categories, T> g) {
        return obj -> g.apply((Categories) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Categories> {
        /**
         * <p>
         * The category rules that have been matched in the analyzed segment.
         * </p>
         * 
         * @param matchedCategories
         *        The category rules that have been matched in the analyzed segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedCategories(Collection<String> matchedCategories);

        /**
         * <p>
         * The category rules that have been matched in the analyzed segment.
         * </p>
         * 
         * @param matchedCategories
         *        The category rules that have been matched in the analyzed segment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedCategories(String... matchedCategories);

        /**
         * <p>
         * The category rule that was matched and when it occurred in the transcript.
         * </p>
         * 
         * @param matchedDetails
         *        The category rule that was matched and when it occurred in the transcript.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchedDetails(Map<String, CategoryDetails> matchedDetails);
    }

    static final class BuilderImpl implements Builder {
        private List<String> matchedCategories = DefaultSdkAutoConstructList.getInstance();

        private Map<String, CategoryDetails> matchedDetails = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Categories model) {
            matchedCategories(model.matchedCategories);
            matchedDetails(model.matchedDetails);
        }

        public final Collection<String> getMatchedCategories() {
            if (matchedCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return matchedCategories;
        }

        @Override
        public final Builder matchedCategories(Collection<String> matchedCategories) {
            this.matchedCategories = MatchedCategoriesCopier.copy(matchedCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedCategories(String... matchedCategories) {
            matchedCategories(Arrays.asList(matchedCategories));
            return this;
        }

        public final void setMatchedCategories(Collection<String> matchedCategories) {
            this.matchedCategories = MatchedCategoriesCopier.copy(matchedCategories);
        }

        public final Map<String, CategoryDetails.Builder> getMatchedDetails() {
            if (matchedDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return matchedDetails != null ? CollectionUtils.mapValues(matchedDetails, CategoryDetails::toBuilder) : null;
        }

        @Override
        public final Builder matchedDetails(Map<String, CategoryDetails> matchedDetails) {
            this.matchedDetails = MatchedDetailsCopier.copy(matchedDetails);
            return this;
        }

        public final void setMatchedDetails(Map<String, CategoryDetails.BuilderImpl> matchedDetails) {
            this.matchedDetails = MatchedDetailsCopier.copyFromBuilder(matchedDetails);
        }

        @Override
        public Categories build() {
            return new Categories(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
