/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.SearchCasesResponseCasesListCopier;
import software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchCasesResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, SearchCasesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchCasesResponse.getter(SearchCasesResponse::nextToken)).setter(SearchCasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SearchCasesResponseItem>> CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cases").getter(SearchCasesResponse.getter(SearchCasesResponse::cases)).setter(SearchCasesResponse.setter(Builder::cases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchCasesResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchCasesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SearchCasesResponseItem> cases;

    private SearchCasesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.cases = builder.cases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasCases() {
        return this.cases != null && !(this.cases instanceof SdkAutoConstructList);
    }

    public final List<SearchCasesResponseItem> cases() {
        return this.cases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCases() ? this.cases() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchCasesResponse)) {
            return false;
        }
        SearchCasesResponse other = (SearchCasesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasCases() == other.hasCases() && Objects.equals(this.cases(), other.cases());
    }

    public final String toString() {
        return ToString.builder((String)"SearchCasesResponse").add("NextToken", (Object)this.nextToken()).add("Cases", this.hasCases() ? this.cases() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "cases": {
                return Optional.ofNullable(clazz.cast(this.cases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("cases", CASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchCasesResponse, T> g) {
        return obj -> g.apply((SearchCasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SearchCasesResponseItem> cases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchCasesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.cases(model.cases);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SearchCasesResponseItem.Builder> getCases() {
            List<SearchCasesResponseItem.Builder> result = SearchCasesResponseCasesListCopier.copyToBuilder(this.cases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCases(Collection<SearchCasesResponseItem.BuilderImpl> cases) {
            this.cases = SearchCasesResponseCasesListCopier.copyFromBuilder(cases);
        }

        @Override
        public final Builder cases(Collection<SearchCasesResponseItem> cases) {
            this.cases = SearchCasesResponseCasesListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(SearchCasesResponseItem ... cases) {
            this.cases(Arrays.asList(cases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(Consumer<SearchCasesResponseItem.Builder> ... cases) {
            this.cases(Stream.of(cases).map(c -> (SearchCasesResponseItem)((SearchCasesResponseItem.Builder)SearchCasesResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchCasesResponse build() {
            return new SearchCasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchCasesResponse> {
        public Builder nextToken(String var1);

        public Builder cases(Collection<SearchCasesResponseItem> var1);

        public Builder cases(SearchCasesResponseItem ... var1);

        public Builder cases(Consumer<SearchCasesResponseItem.Builder> ... var1);
    }
}

