/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.CommentContent;
import software.amazon.awssdk.services.connectcases.model.ConnectCaseInputContent;
import software.amazon.awssdk.services.connectcases.model.Contact;
import software.amazon.awssdk.services.connectcases.model.CustomInputContent;
import software.amazon.awssdk.services.connectcases.model.FileContent;
import software.amazon.awssdk.services.connectcases.model.SlaInputContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedItemInputContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedItemInputContent> {
    private static final SdkField<Contact> CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contact").getter(RelatedItemInputContent.getter(RelatedItemInputContent::contact)).setter(RelatedItemInputContent.setter(Builder::contact)).constructor(Contact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()}).build();
    private static final SdkField<CommentContent> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("comment").getter(RelatedItemInputContent.getter(RelatedItemInputContent::comment)).setter(RelatedItemInputContent.setter(Builder::comment)).constructor(CommentContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<FileContent> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(RelatedItemInputContent.getter(RelatedItemInputContent::file)).setter(RelatedItemInputContent.setter(Builder::file)).constructor(FileContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<SlaInputContent> SLA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sla").getter(RelatedItemInputContent.getter(RelatedItemInputContent::sla)).setter(RelatedItemInputContent.setter(Builder::sla)).constructor(SlaInputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sla").build()}).build();
    private static final SdkField<ConnectCaseInputContent> CONNECT_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("connectCase").getter(RelatedItemInputContent.getter(RelatedItemInputContent::connectCase)).setter(RelatedItemInputContent.setter(Builder::connectCase)).constructor(ConnectCaseInputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectCase").build()}).build();
    private static final SdkField<CustomInputContent> CUSTOM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("custom").getter(RelatedItemInputContent.getter(RelatedItemInputContent::custom)).setter(RelatedItemInputContent.setter(Builder::custom)).constructor(CustomInputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("custom").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_FIELD, COMMENT_FIELD, FILE_FIELD, SLA_FIELD, CONNECT_CASE_FIELD, CUSTOM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelatedItemInputContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Contact contact;
    private final CommentContent comment;
    private final FileContent file;
    private final SlaInputContent sla;
    private final ConnectCaseInputContent connectCase;
    private final CustomInputContent custom;
    private final Type type;

    private RelatedItemInputContent(BuilderImpl builder) {
        this.contact = builder.contact;
        this.comment = builder.comment;
        this.file = builder.file;
        this.sla = builder.sla;
        this.connectCase = builder.connectCase;
        this.custom = builder.custom;
        this.type = builder.type;
    }

    public final Contact contact() {
        return this.contact;
    }

    public final CommentContent comment() {
        return this.comment;
    }

    public final FileContent file() {
        return this.file;
    }

    public final SlaInputContent sla() {
        return this.sla;
    }

    public final ConnectCaseInputContent connectCase() {
        return this.connectCase;
    }

    public final CustomInputContent custom() {
        return this.custom;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contact());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.sla());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.custom());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemInputContent)) {
            return false;
        }
        RelatedItemInputContent other = (RelatedItemInputContent)obj;
        return Objects.equals(this.contact(), other.contact()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.sla(), other.sla()) && Objects.equals(this.connectCase(), other.connectCase()) && Objects.equals(this.custom(), other.custom());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedItemInputContent").add("Contact", (Object)this.contact()).add("Comment", (Object)this.comment()).add("File", (Object)this.file()).add("Sla", (Object)this.sla()).add("ConnectCase", (Object)this.connectCase()).add("Custom", (Object)this.custom()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contact": {
                return Optional.ofNullable(clazz.cast(this.contact()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "sla": {
                return Optional.ofNullable(clazz.cast(this.sla()));
            }
            case "connectCase": {
                return Optional.ofNullable(clazz.cast(this.connectCase()));
            }
            case "custom": {
                return Optional.ofNullable(clazz.cast(this.custom()));
            }
        }
        return Optional.empty();
    }

    public static RelatedItemInputContent fromContact(Contact contact) {
        return (RelatedItemInputContent)RelatedItemInputContent.builder().contact(contact).build();
    }

    public static RelatedItemInputContent fromContact(Consumer<Contact.Builder> contact) {
        Contact.Builder builder = Contact.builder();
        contact.accept(builder);
        return RelatedItemInputContent.fromContact((Contact)builder.build());
    }

    public static RelatedItemInputContent fromComment(CommentContent comment) {
        return (RelatedItemInputContent)RelatedItemInputContent.builder().comment(comment).build();
    }

    public static RelatedItemInputContent fromComment(Consumer<CommentContent.Builder> comment) {
        CommentContent.Builder builder = CommentContent.builder();
        comment.accept(builder);
        return RelatedItemInputContent.fromComment((CommentContent)builder.build());
    }

    public static RelatedItemInputContent fromFile(FileContent file) {
        return (RelatedItemInputContent)RelatedItemInputContent.builder().file(file).build();
    }

    public static RelatedItemInputContent fromFile(Consumer<FileContent.Builder> file) {
        FileContent.Builder builder = FileContent.builder();
        file.accept(builder);
        return RelatedItemInputContent.fromFile((FileContent)builder.build());
    }

    public static RelatedItemInputContent fromSla(SlaInputContent sla) {
        return (RelatedItemInputContent)RelatedItemInputContent.builder().sla(sla).build();
    }

    public static RelatedItemInputContent fromSla(Consumer<SlaInputContent.Builder> sla) {
        SlaInputContent.Builder builder = SlaInputContent.builder();
        sla.accept(builder);
        return RelatedItemInputContent.fromSla((SlaInputContent)builder.build());
    }

    public static RelatedItemInputContent fromConnectCase(ConnectCaseInputContent connectCase) {
        return (RelatedItemInputContent)RelatedItemInputContent.builder().connectCase(connectCase).build();
    }

    public static RelatedItemInputContent fromConnectCase(Consumer<ConnectCaseInputContent.Builder> connectCase) {
        ConnectCaseInputContent.Builder builder = ConnectCaseInputContent.builder();
        connectCase.accept(builder);
        return RelatedItemInputContent.fromConnectCase((ConnectCaseInputContent)builder.build());
    }

    public static RelatedItemInputContent fromCustom(CustomInputContent custom) {
        return (RelatedItemInputContent)RelatedItemInputContent.builder().custom(custom).build();
    }

    public static RelatedItemInputContent fromCustom(Consumer<CustomInputContent.Builder> custom) {
        CustomInputContent.Builder builder = CustomInputContent.builder();
        custom.accept(builder);
        return RelatedItemInputContent.fromCustom((CustomInputContent)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contact", CONTACT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("file", FILE_FIELD);
        map.put("sla", SLA_FIELD);
        map.put("connectCase", CONNECT_CASE_FIELD);
        map.put("custom", CUSTOM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemInputContent, T> g) {
        return obj -> g.apply((RelatedItemInputContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONTACT,
        COMMENT,
        FILE,
        SLA,
        CONNECT_CASE,
        CUSTOM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Contact contact;
        private CommentContent comment;
        private FileContent file;
        private SlaInputContent sla;
        private ConnectCaseInputContent connectCase;
        private CustomInputContent custom;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemInputContent model) {
            this.contact(model.contact);
            this.comment(model.comment);
            this.file(model.file);
            this.sla(model.sla);
            this.connectCase(model.connectCase);
            this.custom(model.custom);
        }

        public final Contact.Builder getContact() {
            return this.contact != null ? this.contact.toBuilder() : null;
        }

        public final void setContact(Contact.BuilderImpl contact) {
            Contact oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(Contact contact) {
            Contact oldValue = this.contact;
            this.contact = contact;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        public final CommentContent.Builder getComment() {
            return this.comment != null ? this.comment.toBuilder() : null;
        }

        public final void setComment(CommentContent.BuilderImpl comment) {
            CommentContent oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentContent comment) {
            CommentContent oldValue = this.comment;
            this.comment = comment;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final FileContent.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(FileContent.BuilderImpl file) {
            FileContent oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(FileContent file) {
            FileContent oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final SlaInputContent.Builder getSla() {
            return this.sla != null ? this.sla.toBuilder() : null;
        }

        public final void setSla(SlaInputContent.BuilderImpl sla) {
            SlaInputContent oldValue = this.sla;
            this.sla = sla != null ? sla.build() : null;
            this.handleUnionValueChange(Type.SLA, oldValue, this.sla);
        }

        @Override
        public final Builder sla(SlaInputContent sla) {
            SlaInputContent oldValue = this.sla;
            this.sla = sla;
            this.handleUnionValueChange(Type.SLA, oldValue, this.sla);
            return this;
        }

        public final ConnectCaseInputContent.Builder getConnectCase() {
            return this.connectCase != null ? this.connectCase.toBuilder() : null;
        }

        public final void setConnectCase(ConnectCaseInputContent.BuilderImpl connectCase) {
            ConnectCaseInputContent oldValue = this.connectCase;
            this.connectCase = connectCase != null ? connectCase.build() : null;
            this.handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
        }

        @Override
        public final Builder connectCase(ConnectCaseInputContent connectCase) {
            ConnectCaseInputContent oldValue = this.connectCase;
            this.connectCase = connectCase;
            this.handleUnionValueChange(Type.CONNECT_CASE, oldValue, this.connectCase);
            return this;
        }

        public final CustomInputContent.Builder getCustom() {
            return this.custom != null ? this.custom.toBuilder() : null;
        }

        public final void setCustom(CustomInputContent.BuilderImpl custom) {
            CustomInputContent oldValue = this.custom;
            this.custom = custom != null ? custom.build() : null;
            this.handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
        }

        @Override
        public final Builder custom(CustomInputContent custom) {
            CustomInputContent oldValue = this.custom;
            this.custom = custom;
            this.handleUnionValueChange(Type.CUSTOM, oldValue, this.custom);
            return this;
        }

        public RelatedItemInputContent build() {
            return new RelatedItemInputContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedItemInputContent> {
        public Builder contact(Contact var1);

        default public Builder contact(Consumer<Contact.Builder> contact) {
            return this.contact((Contact)((Contact.Builder)Contact.builder().applyMutation(contact)).build());
        }

        public Builder comment(CommentContent var1);

        default public Builder comment(Consumer<CommentContent.Builder> comment) {
            return this.comment((CommentContent)((CommentContent.Builder)CommentContent.builder().applyMutation(comment)).build());
        }

        public Builder file(FileContent var1);

        default public Builder file(Consumer<FileContent.Builder> file) {
            return this.file((FileContent)((FileContent.Builder)FileContent.builder().applyMutation(file)).build());
        }

        public Builder sla(SlaInputContent var1);

        default public Builder sla(Consumer<SlaInputContent.Builder> sla) {
            return this.sla((SlaInputContent)((SlaInputContent.Builder)SlaInputContent.builder().applyMutation(sla)).build());
        }

        public Builder connectCase(ConnectCaseInputContent var1);

        default public Builder connectCase(Consumer<ConnectCaseInputContent.Builder> connectCase) {
            return this.connectCase((ConnectCaseInputContent)((ConnectCaseInputContent.Builder)ConnectCaseInputContent.builder().applyMutation(connectCase)).build());
        }

        public Builder custom(CustomInputContent var1);

        default public Builder custom(Consumer<CustomInputContent.Builder> custom) {
            return this.custom((CustomInputContent)((CustomInputContent.Builder)CustomInputContent.builder().applyMutation(custom)).build());
        }
    }
}

