/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the right hand operand in the condition. In the Amazon Connect admin website, case rules are known as
 * <i>case field conditions</i>. For more information about case field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add case field conditions to
 * a case template</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperandTwo implements SdkPojo, Serializable, ToCopyableBuilder<OperandTwo.Builder, OperandTwo> {
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(OperandTwo::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("booleanValue").getter(getter(OperandTwo::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("doubleValue").getter(getter(OperandTwo::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<EmptyOperandValue> EMPTY_VALUE_FIELD = SdkField
            .<EmptyOperandValue> builder(MarshallingType.SDK_POJO).memberName("emptyValue")
            .getter(getter(OperandTwo::emptyValue)).setter(setter(Builder::emptyValue)).constructor(EmptyOperandValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("emptyValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_VALUE_FIELD,
            BOOLEAN_VALUE_FIELD, DOUBLE_VALUE_FIELD, EMPTY_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stringValue;

    private final Boolean booleanValue;

    private final Double doubleValue;

    private final EmptyOperandValue emptyValue;

    private final Type type;

    private OperandTwo(BuilderImpl builder) {
        this.stringValue = builder.stringValue;
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.emptyValue = builder.emptyValue;
        this.type = builder.type;
    }

    /**
     * <p>
     * String value type.
     * </p>
     * 
     * @return String value type.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * <p>
     * Boolean value type.
     * </p>
     * 
     * @return Boolean value type.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * Double value type.
     * </p>
     * 
     * @return Double value type.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * Empty value type.
     * </p>
     * 
     * @return Empty value type.
     */
    public final EmptyOperandValue emptyValue() {
        return emptyValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(emptyValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperandTwo)) {
            return false;
        }
        OperandTwo other = (OperandTwo) obj;
        return Objects.equals(stringValue(), other.stringValue()) && Objects.equals(booleanValue(), other.booleanValue())
                && Objects.equals(doubleValue(), other.doubleValue()) && Objects.equals(emptyValue(), other.emptyValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OperandTwo").add("StringValue", stringValue()).add("BooleanValue", booleanValue())
                .add("DoubleValue", doubleValue()).add("EmptyValue", emptyValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "emptyValue":
            return Optional.ofNullable(clazz.cast(emptyValue()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #stringValue()} initialized to the given value.
     *
     * <p>
     * String value type.
     * </p>
     * 
     * @param stringValue
     *        String value type.
     */
    public static OperandTwo fromStringValue(String stringValue) {
        return builder().stringValue(stringValue).build();
    }

    /**
     * Create an instance of this class with {@link #booleanValue()} initialized to the given value.
     *
     * <p>
     * Boolean value type.
     * </p>
     * 
     * @param booleanValue
     *        Boolean value type.
     */
    public static OperandTwo fromBooleanValue(Boolean booleanValue) {
        return builder().booleanValue(booleanValue).build();
    }

    /**
     * Create an instance of this class with {@link #doubleValue()} initialized to the given value.
     *
     * <p>
     * Double value type.
     * </p>
     * 
     * @param doubleValue
     *        Double value type.
     */
    public static OperandTwo fromDoubleValue(Double doubleValue) {
        return builder().doubleValue(doubleValue).build();
    }

    /**
     * Create an instance of this class with {@link #emptyValue()} initialized to the given value.
     *
     * <p>
     * Empty value type.
     * </p>
     * 
     * @param emptyValue
     *        Empty value type.
     */
    public static OperandTwo fromEmptyValue(EmptyOperandValue emptyValue) {
        return builder().emptyValue(emptyValue).build();
    }

    /**
     * Create an instance of this class with {@link #emptyValue()} initialized to the given value.
     *
     * <p>
     * Empty value type.
     * </p>
     * 
     * @param emptyValue
     *        Empty value type.
     */
    public static OperandTwo fromEmptyValue(Consumer<EmptyOperandValue.Builder> emptyValue) {
        EmptyOperandValue.Builder builder = EmptyOperandValue.builder();
        emptyValue.accept(builder);
        return fromEmptyValue(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("booleanValue", BOOLEAN_VALUE_FIELD);
        map.put("doubleValue", DOUBLE_VALUE_FIELD);
        map.put("emptyValue", EMPTY_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OperandTwo, T> g) {
        return obj -> g.apply((OperandTwo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperandTwo> {
        /**
         * <p>
         * String value type.
         * </p>
         * 
         * @param stringValue
         *        String value type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * Boolean value type.
         * </p>
         * 
         * @param booleanValue
         *        Boolean value type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * Double value type.
         * </p>
         * 
         * @param doubleValue
         *        Double value type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * Empty value type.
         * </p>
         * 
         * @param emptyValue
         *        Empty value type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emptyValue(EmptyOperandValue emptyValue);

        /**
         * <p>
         * Empty value type.
         * </p>
         * This is a convenience method that creates an instance of the {@link EmptyOperandValue.Builder} avoiding the
         * need to create one manually via {@link EmptyOperandValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EmptyOperandValue.Builder#build()} is called immediately and its
         * result is passed to {@link #emptyValue(EmptyOperandValue)}.
         * 
         * @param emptyValue
         *        a consumer that will call methods on {@link EmptyOperandValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #emptyValue(EmptyOperandValue)
         */
        default Builder emptyValue(Consumer<EmptyOperandValue.Builder> emptyValue) {
            return emptyValue(EmptyOperandValue.builder().applyMutation(emptyValue).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stringValue;

        private Boolean booleanValue;

        private Double doubleValue;

        private EmptyOperandValue emptyValue;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(OperandTwo model) {
            stringValue(model.stringValue);
            booleanValue(model.booleanValue);
            doubleValue(model.doubleValue);
            emptyValue(model.emptyValue);
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
        }

        @Override
        public final Builder stringValue(String stringValue) {
            Object oldValue = this.stringValue;
            this.stringValue = stringValue;
            handleUnionValueChange(Type.STRING_VALUE, oldValue, this.stringValue);
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            Object oldValue = this.booleanValue;
            this.booleanValue = booleanValue;
            handleUnionValueChange(Type.BOOLEAN_VALUE, oldValue, this.booleanValue);
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            Object oldValue = this.doubleValue;
            this.doubleValue = doubleValue;
            handleUnionValueChange(Type.DOUBLE_VALUE, oldValue, this.doubleValue);
            return this;
        }

        public final EmptyOperandValue.Builder getEmptyValue() {
            return emptyValue != null ? emptyValue.toBuilder() : null;
        }

        public final void setEmptyValue(EmptyOperandValue.BuilderImpl emptyValue) {
            Object oldValue = this.emptyValue;
            this.emptyValue = emptyValue != null ? emptyValue.build() : null;
            handleUnionValueChange(Type.EMPTY_VALUE, oldValue, this.emptyValue);
        }

        @Override
        public final Builder emptyValue(EmptyOperandValue emptyValue) {
            Object oldValue = this.emptyValue;
            this.emptyValue = emptyValue;
            handleUnionValueChange(Type.EMPTY_VALUE, oldValue, this.emptyValue);
            return this;
        }

        @Override
        public OperandTwo build() {
            return new OperandTwo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see OperandTwo#type()
     */
    public enum Type {
        STRING_VALUE,

        BOOLEAN_VALUE,

        DOUBLE_VALUE,

        EMPTY_VALUE,

        UNKNOWN_TO_SDK_VERSION
    }
}
