/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Ordered list containing different kinds of sections that can be added. A LayoutSections object can only contain one
 * section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LayoutSections implements SdkPojo, Serializable, ToCopyableBuilder<LayoutSections.Builder, LayoutSections> {
    private static final SdkField<List<Section>> SECTIONS_FIELD = SdkField
            .<List<Section>> builder(MarshallingType.LIST)
            .memberName("sections")
            .getter(getter(LayoutSections::sections))
            .setter(setter(Builder::sections))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sections").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Section> builder(MarshallingType.SDK_POJO)
                                            .constructor(Section::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Section> sections;

    private LayoutSections(BuilderImpl builder) {
        this.sections = builder.sections;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sections property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSections() {
        return sections != null && !(sections instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Sections property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSections} method.
     * </p>
     * 
     * @return The value of the Sections property for this object.
     */
    public final List<Section> sections() {
        return sections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSections() ? sections() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LayoutSections)) {
            return false;
        }
        LayoutSections other = (LayoutSections) obj;
        return hasSections() == other.hasSections() && Objects.equals(sections(), other.sections());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LayoutSections").add("Sections", hasSections() ? sections() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sections":
            return Optional.ofNullable(clazz.cast(sections()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sections", SECTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LayoutSections, T> g) {
        return obj -> g.apply((LayoutSections) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LayoutSections> {
        /**
         * Sets the value of the Sections property for this object.
         *
         * @param sections
         *        The new value for the Sections property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sections(Collection<Section> sections);

        /**
         * Sets the value of the Sections property for this object.
         *
         * @param sections
         *        The new value for the Sections property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sections(Section... sections);

        /**
         * Sets the value of the Sections property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.connectcases.model.Section.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.connectcases.model.Section#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.connectcases.model.Section.Builder#build()} is called immediately and
         * its result is passed to {@link #sections(List<Section>)}.
         * 
         * @param sections
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.connectcases.model.Section.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sections(java.util.Collection<Section>)
         */
        Builder sections(Consumer<Section.Builder>... sections);
    }

    static final class BuilderImpl implements Builder {
        private List<Section> sections = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LayoutSections model) {
            sections(model.sections);
        }

        public final List<Section.Builder> getSections() {
            List<Section.Builder> result = SectionsListCopier.copyToBuilder(this.sections);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSections(Collection<Section.BuilderImpl> sections) {
            this.sections = SectionsListCopier.copyFromBuilder(sections);
        }

        @Override
        public final Builder sections(Collection<Section> sections) {
            this.sections = SectionsListCopier.copy(sections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sections(Section... sections) {
            sections(Arrays.asList(sections));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sections(Consumer<Section.Builder>... sections) {
            sections(Stream.of(sections).map(c -> Section.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LayoutSections build() {
            return new LayoutSections(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
