/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for fields. Only one value can be provided.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldFilter implements SdkPojo, Serializable, ToCopyableBuilder<FieldFilter.Builder, FieldFilter> {
    private static final SdkField<FieldValue> EQUAL_TO_FIELD = SdkField.<FieldValue> builder(MarshallingType.SDK_POJO)
            .memberName("equalTo").getter(getter(FieldFilter::equalTo)).setter(setter(Builder::equalTo))
            .constructor(FieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equalTo").build()).build();

    private static final SdkField<FieldValue> CONTAINS_FIELD = SdkField.<FieldValue> builder(MarshallingType.SDK_POJO)
            .memberName("contains").getter(getter(FieldFilter::contains)).setter(setter(Builder::contains))
            .constructor(FieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contains").build()).build();

    private static final SdkField<FieldValue> GREATER_THAN_FIELD = SdkField.<FieldValue> builder(MarshallingType.SDK_POJO)
            .memberName("greaterThan").getter(getter(FieldFilter::greaterThan)).setter(setter(Builder::greaterThan))
            .constructor(FieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();

    private static final SdkField<FieldValue> GREATER_THAN_OR_EQUAL_TO_FIELD = SdkField
            .<FieldValue> builder(MarshallingType.SDK_POJO).memberName("greaterThanOrEqualTo")
            .getter(getter(FieldFilter::greaterThanOrEqualTo)).setter(setter(Builder::greaterThanOrEqualTo))
            .constructor(FieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEqualTo").build())
            .build();

    private static final SdkField<FieldValue> LESS_THAN_FIELD = SdkField.<FieldValue> builder(MarshallingType.SDK_POJO)
            .memberName("lessThan").getter(getter(FieldFilter::lessThan)).setter(setter(Builder::lessThan))
            .constructor(FieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();

    private static final SdkField<FieldValue> LESS_THAN_OR_EQUAL_TO_FIELD = SdkField
            .<FieldValue> builder(MarshallingType.SDK_POJO).memberName("lessThanOrEqualTo")
            .getter(getter(FieldFilter::lessThanOrEqualTo)).setter(setter(Builder::lessThanOrEqualTo))
            .constructor(FieldValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEqualTo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUAL_TO_FIELD,
            CONTAINS_FIELD, GREATER_THAN_FIELD, GREATER_THAN_OR_EQUAL_TO_FIELD, LESS_THAN_FIELD, LESS_THAN_OR_EQUAL_TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FieldValue equalTo;

    private final FieldValue contains;

    private final FieldValue greaterThan;

    private final FieldValue greaterThanOrEqualTo;

    private final FieldValue lessThan;

    private final FieldValue lessThanOrEqualTo;

    private final Type type;

    private FieldFilter(BuilderImpl builder) {
        this.equalTo = builder.equalTo;
        this.contains = builder.contains;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEqualTo = builder.greaterThanOrEqualTo;
        this.lessThan = builder.lessThan;
        this.lessThanOrEqualTo = builder.lessThanOrEqualTo;
        this.type = builder.type;
    }

    /**
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @return Object containing field identifier and value information.
     */
    public final FieldValue equalTo() {
        return equalTo;
    }

    /**
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @return Object containing field identifier and value information.
     */
    public final FieldValue contains() {
        return contains;
    }

    /**
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @return Object containing field identifier and value information.
     */
    public final FieldValue greaterThan() {
        return greaterThan;
    }

    /**
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @return Object containing field identifier and value information.
     */
    public final FieldValue greaterThanOrEqualTo() {
        return greaterThanOrEqualTo;
    }

    /**
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @return Object containing field identifier and value information.
     */
    public final FieldValue lessThan() {
        return lessThan;
    }

    /**
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @return Object containing field identifier and value information.
     */
    public final FieldValue lessThanOrEqualTo() {
        return lessThanOrEqualTo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(equalTo());
        hashCode = 31 * hashCode + Objects.hashCode(contains());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(greaterThanOrEqualTo());
        hashCode = 31 * hashCode + Objects.hashCode(lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(lessThanOrEqualTo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldFilter)) {
            return false;
        }
        FieldFilter other = (FieldFilter) obj;
        return Objects.equals(equalTo(), other.equalTo()) && Objects.equals(contains(), other.contains())
                && Objects.equals(greaterThan(), other.greaterThan())
                && Objects.equals(greaterThanOrEqualTo(), other.greaterThanOrEqualTo())
                && Objects.equals(lessThan(), other.lessThan()) && Objects.equals(lessThanOrEqualTo(), other.lessThanOrEqualTo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldFilter").add("EqualTo", equalTo()).add("Contains", contains())
                .add("GreaterThan", greaterThan()).add("GreaterThanOrEqualTo", greaterThanOrEqualTo())
                .add("LessThan", lessThan()).add("LessThanOrEqualTo", lessThanOrEqualTo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "equalTo":
            return Optional.ofNullable(clazz.cast(equalTo()));
        case "contains":
            return Optional.ofNullable(clazz.cast(contains()));
        case "greaterThan":
            return Optional.ofNullable(clazz.cast(greaterThan()));
        case "greaterThanOrEqualTo":
            return Optional.ofNullable(clazz.cast(greaterThanOrEqualTo()));
        case "lessThan":
            return Optional.ofNullable(clazz.cast(lessThan()));
        case "lessThanOrEqualTo":
            return Optional.ofNullable(clazz.cast(lessThanOrEqualTo()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #equalTo()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param equalTo
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromEqualTo(FieldValue equalTo) {
        return builder().equalTo(equalTo).build();
    }

    /**
     * Create an instance of this class with {@link #equalTo()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param equalTo
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromEqualTo(Consumer<FieldValue.Builder> equalTo) {
        FieldValue.Builder builder = FieldValue.builder();
        equalTo.accept(builder);
        return fromEqualTo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #contains()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param contains
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromContains(FieldValue contains) {
        return builder().contains(contains).build();
    }

    /**
     * Create an instance of this class with {@link #contains()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param contains
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromContains(Consumer<FieldValue.Builder> contains) {
        FieldValue.Builder builder = FieldValue.builder();
        contains.accept(builder);
        return fromContains(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param greaterThan
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromGreaterThan(FieldValue greaterThan) {
        return builder().greaterThan(greaterThan).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThan()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param greaterThan
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromGreaterThan(Consumer<FieldValue.Builder> greaterThan) {
        FieldValue.Builder builder = FieldValue.builder();
        greaterThan.accept(builder);
        return fromGreaterThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param greaterThanOrEqualTo
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromGreaterThanOrEqualTo(FieldValue greaterThanOrEqualTo) {
        return builder().greaterThanOrEqualTo(greaterThanOrEqualTo).build();
    }

    /**
     * Create an instance of this class with {@link #greaterThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param greaterThanOrEqualTo
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromGreaterThanOrEqualTo(Consumer<FieldValue.Builder> greaterThanOrEqualTo) {
        FieldValue.Builder builder = FieldValue.builder();
        greaterThanOrEqualTo.accept(builder);
        return fromGreaterThanOrEqualTo(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param lessThan
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromLessThan(FieldValue lessThan) {
        return builder().lessThan(lessThan).build();
    }

    /**
     * Create an instance of this class with {@link #lessThan()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param lessThan
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromLessThan(Consumer<FieldValue.Builder> lessThan) {
        FieldValue.Builder builder = FieldValue.builder();
        lessThan.accept(builder);
        return fromLessThan(builder.build());
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param lessThanOrEqualTo
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromLessThanOrEqualTo(FieldValue lessThanOrEqualTo) {
        return builder().lessThanOrEqualTo(lessThanOrEqualTo).build();
    }

    /**
     * Create an instance of this class with {@link #lessThanOrEqualTo()} initialized to the given value.
     *
     * <p>
     * Object containing field identifier and value information.
     * </p>
     * 
     * @param lessThanOrEqualTo
     *        Object containing field identifier and value information.
     */
    public static FieldFilter fromLessThanOrEqualTo(Consumer<FieldValue.Builder> lessThanOrEqualTo) {
        FieldValue.Builder builder = FieldValue.builder();
        lessThanOrEqualTo.accept(builder);
        return fromLessThanOrEqualTo(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("equalTo", EQUAL_TO_FIELD);
        map.put("contains", CONTAINS_FIELD);
        map.put("greaterThan", GREATER_THAN_FIELD);
        map.put("greaterThanOrEqualTo", GREATER_THAN_OR_EQUAL_TO_FIELD);
        map.put("lessThan", LESS_THAN_FIELD);
        map.put("lessThanOrEqualTo", LESS_THAN_OR_EQUAL_TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FieldFilter, T> g) {
        return obj -> g.apply((FieldFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldFilter> {
        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * 
         * @param equalTo
         *        Object containing field identifier and value information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder equalTo(FieldValue equalTo);

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldValue.Builder} avoiding the need to
         * create one manually via {@link FieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldValue.Builder#build()} is called immediately and its result
         * is passed to {@link #equalTo(FieldValue)}.
         * 
         * @param equalTo
         *        a consumer that will call methods on {@link FieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #equalTo(FieldValue)
         */
        default Builder equalTo(Consumer<FieldValue.Builder> equalTo) {
            return equalTo(FieldValue.builder().applyMutation(equalTo).build());
        }

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * 
         * @param contains
         *        Object containing field identifier and value information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contains(FieldValue contains);

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldValue.Builder} avoiding the need to
         * create one manually via {@link FieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldValue.Builder#build()} is called immediately and its result
         * is passed to {@link #contains(FieldValue)}.
         * 
         * @param contains
         *        a consumer that will call methods on {@link FieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contains(FieldValue)
         */
        default Builder contains(Consumer<FieldValue.Builder> contains) {
            return contains(FieldValue.builder().applyMutation(contains).build());
        }

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * 
         * @param greaterThan
         *        Object containing field identifier and value information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThan(FieldValue greaterThan);

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldValue.Builder} avoiding the need to
         * create one manually via {@link FieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldValue.Builder#build()} is called immediately and its result
         * is passed to {@link #greaterThan(FieldValue)}.
         * 
         * @param greaterThan
         *        a consumer that will call methods on {@link FieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThan(FieldValue)
         */
        default Builder greaterThan(Consumer<FieldValue.Builder> greaterThan) {
            return greaterThan(FieldValue.builder().applyMutation(greaterThan).build());
        }

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * 
         * @param greaterThanOrEqualTo
         *        Object containing field identifier and value information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder greaterThanOrEqualTo(FieldValue greaterThanOrEqualTo);

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldValue.Builder} avoiding the need to
         * create one manually via {@link FieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldValue.Builder#build()} is called immediately and its result
         * is passed to {@link #greaterThanOrEqualTo(FieldValue)}.
         * 
         * @param greaterThanOrEqualTo
         *        a consumer that will call methods on {@link FieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #greaterThanOrEqualTo(FieldValue)
         */
        default Builder greaterThanOrEqualTo(Consumer<FieldValue.Builder> greaterThanOrEqualTo) {
            return greaterThanOrEqualTo(FieldValue.builder().applyMutation(greaterThanOrEqualTo).build());
        }

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * 
         * @param lessThan
         *        Object containing field identifier and value information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThan(FieldValue lessThan);

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldValue.Builder} avoiding the need to
         * create one manually via {@link FieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldValue.Builder#build()} is called immediately and its result
         * is passed to {@link #lessThan(FieldValue)}.
         * 
         * @param lessThan
         *        a consumer that will call methods on {@link FieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThan(FieldValue)
         */
        default Builder lessThan(Consumer<FieldValue.Builder> lessThan) {
            return lessThan(FieldValue.builder().applyMutation(lessThan).build());
        }

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * 
         * @param lessThanOrEqualTo
         *        Object containing field identifier and value information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lessThanOrEqualTo(FieldValue lessThanOrEqualTo);

        /**
         * <p>
         * Object containing field identifier and value information.
         * </p>
         * This is a convenience method that creates an instance of the {@link FieldValue.Builder} avoiding the need to
         * create one manually via {@link FieldValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FieldValue.Builder#build()} is called immediately and its result
         * is passed to {@link #lessThanOrEqualTo(FieldValue)}.
         * 
         * @param lessThanOrEqualTo
         *        a consumer that will call methods on {@link FieldValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lessThanOrEqualTo(FieldValue)
         */
        default Builder lessThanOrEqualTo(Consumer<FieldValue.Builder> lessThanOrEqualTo) {
            return lessThanOrEqualTo(FieldValue.builder().applyMutation(lessThanOrEqualTo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FieldValue equalTo;

        private FieldValue contains;

        private FieldValue greaterThan;

        private FieldValue greaterThanOrEqualTo;

        private FieldValue lessThan;

        private FieldValue lessThanOrEqualTo;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FieldFilter model) {
            equalTo(model.equalTo);
            contains(model.contains);
            greaterThan(model.greaterThan);
            greaterThanOrEqualTo(model.greaterThanOrEqualTo);
            lessThan(model.lessThan);
            lessThanOrEqualTo(model.lessThanOrEqualTo);
        }

        public final FieldValue.Builder getEqualTo() {
            return equalTo != null ? equalTo.toBuilder() : null;
        }

        public final void setEqualTo(FieldValue.BuilderImpl equalTo) {
            Object oldValue = this.equalTo;
            this.equalTo = equalTo != null ? equalTo.build() : null;
            handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
        }

        @Override
        public final Builder equalTo(FieldValue equalTo) {
            Object oldValue = this.equalTo;
            this.equalTo = equalTo;
            handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
            return this;
        }

        public final FieldValue.Builder getContains() {
            return contains != null ? contains.toBuilder() : null;
        }

        public final void setContains(FieldValue.BuilderImpl contains) {
            Object oldValue = this.contains;
            this.contains = contains != null ? contains.build() : null;
            handleUnionValueChange(Type.CONTAINS, oldValue, this.contains);
        }

        @Override
        public final Builder contains(FieldValue contains) {
            Object oldValue = this.contains;
            this.contains = contains;
            handleUnionValueChange(Type.CONTAINS, oldValue, this.contains);
            return this;
        }

        public final FieldValue.Builder getGreaterThan() {
            return greaterThan != null ? greaterThan.toBuilder() : null;
        }

        public final void setGreaterThan(FieldValue.BuilderImpl greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan != null ? greaterThan.build() : null;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
        }

        @Override
        public final Builder greaterThan(FieldValue greaterThan) {
            Object oldValue = this.greaterThan;
            this.greaterThan = greaterThan;
            handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
            return this;
        }

        public final FieldValue.Builder getGreaterThanOrEqualTo() {
            return greaterThanOrEqualTo != null ? greaterThanOrEqualTo.toBuilder() : null;
        }

        public final void setGreaterThanOrEqualTo(FieldValue.BuilderImpl greaterThanOrEqualTo) {
            Object oldValue = this.greaterThanOrEqualTo;
            this.greaterThanOrEqualTo = greaterThanOrEqualTo != null ? greaterThanOrEqualTo.build() : null;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUAL_TO, oldValue, this.greaterThanOrEqualTo);
        }

        @Override
        public final Builder greaterThanOrEqualTo(FieldValue greaterThanOrEqualTo) {
            Object oldValue = this.greaterThanOrEqualTo;
            this.greaterThanOrEqualTo = greaterThanOrEqualTo;
            handleUnionValueChange(Type.GREATER_THAN_OR_EQUAL_TO, oldValue, this.greaterThanOrEqualTo);
            return this;
        }

        public final FieldValue.Builder getLessThan() {
            return lessThan != null ? lessThan.toBuilder() : null;
        }

        public final void setLessThan(FieldValue.BuilderImpl lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan != null ? lessThan.build() : null;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
        }

        @Override
        public final Builder lessThan(FieldValue lessThan) {
            Object oldValue = this.lessThan;
            this.lessThan = lessThan;
            handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
            return this;
        }

        public final FieldValue.Builder getLessThanOrEqualTo() {
            return lessThanOrEqualTo != null ? lessThanOrEqualTo.toBuilder() : null;
        }

        public final void setLessThanOrEqualTo(FieldValue.BuilderImpl lessThanOrEqualTo) {
            Object oldValue = this.lessThanOrEqualTo;
            this.lessThanOrEqualTo = lessThanOrEqualTo != null ? lessThanOrEqualTo.build() : null;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUAL_TO, oldValue, this.lessThanOrEqualTo);
        }

        @Override
        public final Builder lessThanOrEqualTo(FieldValue lessThanOrEqualTo) {
            Object oldValue = this.lessThanOrEqualTo;
            this.lessThanOrEqualTo = lessThanOrEqualTo;
            handleUnionValueChange(Type.LESS_THAN_OR_EQUAL_TO, oldValue, this.lessThanOrEqualTo);
            return this;
        }

        @Override
        public FieldFilter build() {
            return new FieldFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FieldFilter#type()
     */
    public enum Type {
        EQUAL_TO,

        CONTAINS,

        GREATER_THAN,

        GREATER_THAN_OR_EQUAL_TO,

        LESS_THAN,

        LESS_THAN_OR_EQUAL_TO,

        UNKNOWN_TO_SDK_VERSION
    }
}
