/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCaseRuleResponse extends ConnectCasesResponse implements
        ToCopyableBuilder<CreateCaseRuleResponse.Builder, CreateCaseRuleResponse> {
    private static final SdkField<String> CASE_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseRuleId").getter(getter(CreateCaseRuleResponse::caseRuleId)).setter(setter(Builder::caseRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleId").build()).build();

    private static final SdkField<String> CASE_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseRuleArn").getter(getter(CreateCaseRuleResponse::caseRuleArn)).setter(setter(Builder::caseRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULE_ID_FIELD,
            CASE_RULE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseRuleId;

    private final String caseRuleArn;

    private CreateCaseRuleResponse(BuilderImpl builder) {
        super(builder);
        this.caseRuleId = builder.caseRuleId;
        this.caseRuleArn = builder.caseRuleArn;
    }

    /**
     * <p>
     * Unique identifier of a case rule.
     * </p>
     * 
     * @return Unique identifier of a case rule.
     */
    public final String caseRuleId() {
        return caseRuleId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a case rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a case rule.
     */
    public final String caseRuleArn() {
        return caseRuleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(caseRuleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRuleResponse)) {
            return false;
        }
        CreateCaseRuleResponse other = (CreateCaseRuleResponse) obj;
        return Objects.equals(caseRuleId(), other.caseRuleId()) && Objects.equals(caseRuleArn(), other.caseRuleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCaseRuleResponse").add("CaseRuleId", caseRuleId()).add("CaseRuleArn", caseRuleArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseRuleId":
            return Optional.ofNullable(clazz.cast(caseRuleId()));
        case "caseRuleArn":
            return Optional.ofNullable(clazz.cast(caseRuleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseRuleId", CASE_RULE_ID_FIELD);
        map.put("caseRuleArn", CASE_RULE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCaseRuleResponse, T> g) {
        return obj -> g.apply((CreateCaseRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ConnectCasesResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateCaseRuleResponse> {
        /**
         * <p>
         * Unique identifier of a case rule.
         * </p>
         * 
         * @param caseRuleId
         *        Unique identifier of a case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRuleId(String caseRuleId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a case rule.
         * </p>
         * 
         * @param caseRuleArn
         *        The Amazon Resource Name (ARN) of a case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRuleArn(String caseRuleArn);
    }

    static final class BuilderImpl extends ConnectCasesResponse.BuilderImpl implements Builder {
        private String caseRuleId;

        private String caseRuleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRuleResponse model) {
            super(model);
            caseRuleId(model.caseRuleId);
            caseRuleArn(model.caseRuleArn);
        }

        public final String getCaseRuleId() {
            return caseRuleId;
        }

        public final void setCaseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
        }

        @Override
        public final Builder caseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
            return this;
        }

        public final String getCaseRuleArn() {
            return caseRuleArn;
        }

        public final void setCaseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
        }

        @Override
        public final Builder caseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
            return this;
        }

        @Override
        public CreateCaseRuleResponse build() {
            return new CreateCaseRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
