/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information of this case rule. In the Amazon Connect admin website, case rules are known as <i>case field
 * conditions</i>. For more information about case field conditions, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/case-field-conditions.html">Add case field conditions to
 * a case template</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseRuleSummary implements SdkPojo, Serializable, ToCopyableBuilder<CaseRuleSummary.Builder, CaseRuleSummary> {
    private static final SdkField<String> CASE_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseRuleId").getter(getter(CaseRuleSummary::caseRuleId)).setter(setter(Builder::caseRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CaseRuleSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CASE_RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseRuleArn").getter(getter(CaseRuleSummary::caseRuleArn)).setter(setter(Builder::caseRuleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseRuleArn").build()).build();

    private static final SdkField<String> RULE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleType").getter(getter(CaseRuleSummary::ruleTypeAsString)).setter(setter(Builder::ruleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CaseRuleSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_RULE_ID_FIELD,
            NAME_FIELD, CASE_RULE_ARN_FIELD, RULE_TYPE_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String caseRuleId;

    private final String name;

    private final String caseRuleArn;

    private final String ruleType;

    private final String description;

    private CaseRuleSummary(BuilderImpl builder) {
        this.caseRuleId = builder.caseRuleId;
        this.name = builder.name;
        this.caseRuleArn = builder.caseRuleArn;
        this.ruleType = builder.ruleType;
        this.description = builder.description;
    }

    /**
     * <p>
     * Unique identifier of a case rule.
     * </p>
     * 
     * @return Unique identifier of a case rule.
     */
    public final String caseRuleId() {
        return caseRuleId;
    }

    /**
     * <p>
     * Name of the case rule.
     * </p>
     * 
     * @return Name of the case rule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the case rule.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the case rule.
     */
    public final String caseRuleArn() {
        return caseRuleArn;
    }

    /**
     * <p>
     * Possible types for a rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return Possible types for a rule.
     * @see RuleType
     */
    public final RuleType ruleType() {
        return RuleType.fromValue(ruleType);
    }

    /**
     * <p>
     * Possible types for a rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleType} will
     * return {@link RuleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #ruleTypeAsString}.
     * </p>
     * 
     * @return Possible types for a rule.
     * @see RuleType
     */
    public final String ruleTypeAsString() {
        return ruleType;
    }

    /**
     * <p>
     * Description of a case rule.
     * </p>
     * 
     * @return Description of a case rule.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(caseRuleArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseRuleSummary)) {
            return false;
        }
        CaseRuleSummary other = (CaseRuleSummary) obj;
        return Objects.equals(caseRuleId(), other.caseRuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(caseRuleArn(), other.caseRuleArn())
                && Objects.equals(ruleTypeAsString(), other.ruleTypeAsString())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseRuleSummary").add("CaseRuleId", caseRuleId()).add("Name", name())
                .add("CaseRuleArn", caseRuleArn()).add("RuleType", ruleTypeAsString()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseRuleId":
            return Optional.ofNullable(clazz.cast(caseRuleId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "caseRuleArn":
            return Optional.ofNullable(clazz.cast(caseRuleArn()));
        case "ruleType":
            return Optional.ofNullable(clazz.cast(ruleTypeAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseRuleId", CASE_RULE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("caseRuleArn", CASE_RULE_ARN_FIELD);
        map.put("ruleType", RULE_TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseRuleSummary, T> g) {
        return obj -> g.apply((CaseRuleSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseRuleSummary> {
        /**
         * <p>
         * Unique identifier of a case rule.
         * </p>
         * 
         * @param caseRuleId
         *        Unique identifier of a case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRuleId(String caseRuleId);

        /**
         * <p>
         * Name of the case rule.
         * </p>
         * 
         * @param name
         *        Name of the case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the case rule.
         * </p>
         * 
         * @param caseRuleArn
         *        The Amazon Resource Name (ARN) of the case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseRuleArn(String caseRuleArn);

        /**
         * <p>
         * Possible types for a rule.
         * </p>
         * 
         * @param ruleType
         *        Possible types for a rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(String ruleType);

        /**
         * <p>
         * Possible types for a rule.
         * </p>
         * 
         * @param ruleType
         *        Possible types for a rule.
         * @see RuleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleType
         */
        Builder ruleType(RuleType ruleType);

        /**
         * <p>
         * Description of a case rule.
         * </p>
         * 
         * @param description
         *        Description of a case rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String caseRuleId;

        private String name;

        private String caseRuleArn;

        private String ruleType;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseRuleSummary model) {
            caseRuleId(model.caseRuleId);
            name(model.name);
            caseRuleArn(model.caseRuleArn);
            ruleType(model.ruleType);
            description(model.description);
        }

        public final String getCaseRuleId() {
            return caseRuleId;
        }

        public final void setCaseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
        }

        @Override
        public final Builder caseRuleId(String caseRuleId) {
            this.caseRuleId = caseRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCaseRuleArn() {
            return caseRuleArn;
        }

        public final void setCaseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
        }

        @Override
        public final Builder caseRuleArn(String caseRuleArn) {
            this.caseRuleArn = caseRuleArn;
            return this;
        }

        public final String getRuleType() {
            return ruleType;
        }

        public final void setRuleType(String ruleType) {
            this.ruleType = ruleType;
        }

        @Override
        public final Builder ruleType(String ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @Override
        public final Builder ruleType(RuleType ruleType) {
            this.ruleType(ruleType == null ? null : ruleType.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public CaseRuleSummary build() {
            return new CaseRuleSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
