/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.FieldValueUnion;
import software.amazon.awssdk.services.connectcases.model.SlaFieldValueUnionListCopier;
import software.amazon.awssdk.services.connectcases.model.SlaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SlaInputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SlaInputConfiguration> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldId").getter(SlaInputConfiguration.getter(SlaInputConfiguration::fieldId)).setter(SlaInputConfiguration.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SlaInputConfiguration.getter(SlaInputConfiguration::name)).setter(SlaInputConfiguration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<FieldValueUnion>> TARGET_FIELD_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetFieldValues").getter(SlaInputConfiguration.getter(SlaInputConfiguration::targetFieldValues)).setter(SlaInputConfiguration.setter(Builder::targetFieldValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFieldValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FieldValueUnion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> TARGET_SLA_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("targetSlaMinutes").getter(SlaInputConfiguration.getter(SlaInputConfiguration::targetSlaMinutes)).setter(SlaInputConfiguration.setter(Builder::targetSlaMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSlaMinutes").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SlaInputConfiguration.getter(SlaInputConfiguration::typeAsString)).setter(SlaInputConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, NAME_FIELD, TARGET_FIELD_VALUES_FIELD, TARGET_SLA_MINUTES_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SlaInputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String name;
    private final List<FieldValueUnion> targetFieldValues;
    private final Long targetSlaMinutes;
    private final String type;

    private SlaInputConfiguration(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.name = builder.name;
        this.targetFieldValues = builder.targetFieldValues;
        this.targetSlaMinutes = builder.targetSlaMinutes;
        this.type = builder.type;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasTargetFieldValues() {
        return this.targetFieldValues != null && !(this.targetFieldValues instanceof SdkAutoConstructList);
    }

    public final List<FieldValueUnion> targetFieldValues() {
        return this.targetFieldValues;
    }

    public final Long targetSlaMinutes() {
        return this.targetSlaMinutes;
    }

    public final SlaType type() {
        return SlaType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetFieldValues() ? this.targetFieldValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetSlaMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlaInputConfiguration)) {
            return false;
        }
        SlaInputConfiguration other = (SlaInputConfiguration)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.name(), other.name()) && this.hasTargetFieldValues() == other.hasTargetFieldValues() && Objects.equals(this.targetFieldValues(), other.targetFieldValues()) && Objects.equals(this.targetSlaMinutes(), other.targetSlaMinutes()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SlaInputConfiguration").add("FieldId", (Object)this.fieldId()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("TargetFieldValues", this.hasTargetFieldValues() ? this.targetFieldValues() : null).add("TargetSlaMinutes", (Object)this.targetSlaMinutes()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "targetFieldValues": {
                return Optional.ofNullable(clazz.cast(this.targetFieldValues()));
            }
            case "targetSlaMinutes": {
                return Optional.ofNullable(clazz.cast(this.targetSlaMinutes()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fieldId", FIELD_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("targetFieldValues", TARGET_FIELD_VALUES_FIELD);
        map.put("targetSlaMinutes", TARGET_SLA_MINUTES_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlaInputConfiguration, T> g) {
        return obj -> g.apply((SlaInputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String name;
        private List<FieldValueUnion> targetFieldValues = DefaultSdkAutoConstructList.getInstance();
        private Long targetSlaMinutes;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(SlaInputConfiguration model) {
            this.fieldId(model.fieldId);
            this.name(model.name);
            this.targetFieldValues(model.targetFieldValues);
            this.targetSlaMinutes(model.targetSlaMinutes);
            this.type(model.type);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<FieldValueUnion.Builder> getTargetFieldValues() {
            List<FieldValueUnion.Builder> result = SlaFieldValueUnionListCopier.copyToBuilder(this.targetFieldValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetFieldValues(Collection<FieldValueUnion.BuilderImpl> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copyFromBuilder(targetFieldValues);
        }

        @Override
        public final Builder targetFieldValues(Collection<FieldValueUnion> targetFieldValues) {
            this.targetFieldValues = SlaFieldValueUnionListCopier.copy(targetFieldValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(FieldValueUnion ... targetFieldValues) {
            this.targetFieldValues(Arrays.asList(targetFieldValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetFieldValues(Consumer<FieldValueUnion.Builder> ... targetFieldValues) {
            this.targetFieldValues(Stream.of(targetFieldValues).map(c -> (FieldValueUnion)((FieldValueUnion.Builder)FieldValueUnion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getTargetSlaMinutes() {
            return this.targetSlaMinutes;
        }

        public final void setTargetSlaMinutes(Long targetSlaMinutes) {
            this.targetSlaMinutes = targetSlaMinutes;
        }

        @Override
        public final Builder targetSlaMinutes(Long targetSlaMinutes) {
            this.targetSlaMinutes = targetSlaMinutes;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SlaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public SlaInputConfiguration build() {
            return new SlaInputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SlaInputConfiguration> {
        public Builder fieldId(String var1);

        public Builder name(String var1);

        public Builder targetFieldValues(Collection<FieldValueUnion> var1);

        public Builder targetFieldValues(FieldValueUnion ... var1);

        public Builder targetFieldValues(Consumer<FieldValueUnion.Builder> ... var1);

        public Builder targetSlaMinutes(Long var1);

        public Builder type(String var1);

        public Builder type(SlaType var1);
    }
}

