/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseRelatedItemsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRelatedItemsResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, SearchRelatedItemsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchRelatedItemsResponse.getter(SearchRelatedItemsResponse::nextToken)).setter(SearchRelatedItemsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SearchRelatedItemsResponseItem>> RELATED_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relatedItems").getter(SearchRelatedItemsResponse.getter(SearchRelatedItemsResponse::relatedItems)).setter(SearchRelatedItemsResponse.setter(Builder::relatedItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchRelatedItemsResponseItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RELATED_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchRelatedItemsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<SearchRelatedItemsResponseItem> relatedItems;

    private SearchRelatedItemsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.relatedItems = builder.relatedItems;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRelatedItems() {
        return this.relatedItems != null && !(this.relatedItems instanceof SdkAutoConstructList);
    }

    public final List<SearchRelatedItemsResponseItem> relatedItems() {
        return this.relatedItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelatedItems() ? this.relatedItems() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRelatedItemsResponse)) {
            return false;
        }
        SearchRelatedItemsResponse other = (SearchRelatedItemsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRelatedItems() == other.hasRelatedItems() && Objects.equals(this.relatedItems(), other.relatedItems());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRelatedItemsResponse").add("NextToken", (Object)this.nextToken()).add("RelatedItems", this.hasRelatedItems() ? this.relatedItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "relatedItems": {
                return Optional.ofNullable(clazz.cast(this.relatedItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("relatedItems", RELATED_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchRelatedItemsResponse, T> g) {
        return obj -> g.apply((SearchRelatedItemsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SearchRelatedItemsResponseItem> relatedItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRelatedItemsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.relatedItems(model.relatedItems);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SearchRelatedItemsResponseItem.Builder> getRelatedItems() {
            List<SearchRelatedItemsResponseItem.Builder> result = SearchRelatedItemsResponseRelatedItemsListCopier.copyToBuilder(this.relatedItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedItems(Collection<SearchRelatedItemsResponseItem.BuilderImpl> relatedItems) {
            this.relatedItems = SearchRelatedItemsResponseRelatedItemsListCopier.copyFromBuilder(relatedItems);
        }

        @Override
        public final Builder relatedItems(Collection<SearchRelatedItemsResponseItem> relatedItems) {
            this.relatedItems = SearchRelatedItemsResponseRelatedItemsListCopier.copy(relatedItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedItems(SearchRelatedItemsResponseItem ... relatedItems) {
            this.relatedItems(Arrays.asList(relatedItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedItems(Consumer<SearchRelatedItemsResponseItem.Builder> ... relatedItems) {
            this.relatedItems(Stream.of(relatedItems).map(c -> (SearchRelatedItemsResponseItem)((SearchRelatedItemsResponseItem.Builder)SearchRelatedItemsResponseItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SearchRelatedItemsResponse build() {
            return new SearchRelatedItemsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchRelatedItemsResponse> {
        public Builder nextToken(String var1);

        public Builder relatedItems(Collection<SearchRelatedItemsResponseItem> var1);

        public Builder relatedItems(SearchRelatedItemsResponseItem ... var1);

        public Builder relatedItems(Consumer<SearchRelatedItemsResponseItem.Builder> ... var1);
    }
}

