/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.connectcases.model.CommentContent;
import software.amazon.awssdk.services.connectcases.model.ContactContent;
import software.amazon.awssdk.services.connectcases.model.FileContent;
import software.amazon.awssdk.services.connectcases.model.SlaContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedItemContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedItemContent> {
    private static final SdkField<CommentContent> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("comment").getter(RelatedItemContent.getter(RelatedItemContent::comment)).setter(RelatedItemContent.setter(Builder::comment)).constructor(CommentContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<ContactContent> CONTACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contact").getter(RelatedItemContent.getter(RelatedItemContent::contact)).setter(RelatedItemContent.setter(Builder::contact)).constructor(ContactContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contact").build()}).build();
    private static final SdkField<FileContent> FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("file").getter(RelatedItemContent.getter(RelatedItemContent::file)).setter(RelatedItemContent.setter(Builder::file)).constructor(FileContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("file").build()}).build();
    private static final SdkField<SlaContent> SLA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sla").getter(RelatedItemContent.getter(RelatedItemContent::sla)).setter(RelatedItemContent.setter(Builder::sla)).constructor(SlaContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sla").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, CONTACT_FIELD, FILE_FIELD, SLA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelatedItemContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CommentContent comment;
    private final ContactContent contact;
    private final FileContent file;
    private final SlaContent sla;
    private final Type type;

    private RelatedItemContent(BuilderImpl builder) {
        this.comment = builder.comment;
        this.contact = builder.contact;
        this.file = builder.file;
        this.sla = builder.sla;
        this.type = builder.type;
    }

    public final CommentContent comment() {
        return this.comment;
    }

    public final ContactContent contact() {
        return this.contact;
    }

    public final FileContent file() {
        return this.file;
    }

    public final SlaContent sla() {
        return this.sla;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.contact());
        hashCode = 31 * hashCode + Objects.hashCode(this.file());
        hashCode = 31 * hashCode + Objects.hashCode(this.sla());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedItemContent)) {
            return false;
        }
        RelatedItemContent other = (RelatedItemContent)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.contact(), other.contact()) && Objects.equals(this.file(), other.file()) && Objects.equals(this.sla(), other.sla());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedItemContent").add("Comment", (Object)this.comment()).add("Contact", (Object)this.contact()).add("File", (Object)this.file()).add("Sla", (Object)this.sla()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "contact": {
                return Optional.ofNullable(clazz.cast(this.contact()));
            }
            case "file": {
                return Optional.ofNullable(clazz.cast(this.file()));
            }
            case "sla": {
                return Optional.ofNullable(clazz.cast(this.sla()));
            }
        }
        return Optional.empty();
    }

    public static RelatedItemContent fromComment(CommentContent comment) {
        return (RelatedItemContent)RelatedItemContent.builder().comment(comment).build();
    }

    public static RelatedItemContent fromComment(Consumer<CommentContent.Builder> comment) {
        CommentContent.Builder builder = CommentContent.builder();
        comment.accept(builder);
        return RelatedItemContent.fromComment((CommentContent)builder.build());
    }

    public static RelatedItemContent fromContact(ContactContent contact) {
        return (RelatedItemContent)RelatedItemContent.builder().contact(contact).build();
    }

    public static RelatedItemContent fromContact(Consumer<ContactContent.Builder> contact) {
        ContactContent.Builder builder = ContactContent.builder();
        contact.accept(builder);
        return RelatedItemContent.fromContact((ContactContent)builder.build());
    }

    public static RelatedItemContent fromFile(FileContent file) {
        return (RelatedItemContent)RelatedItemContent.builder().file(file).build();
    }

    public static RelatedItemContent fromFile(Consumer<FileContent.Builder> file) {
        FileContent.Builder builder = FileContent.builder();
        file.accept(builder);
        return RelatedItemContent.fromFile((FileContent)builder.build());
    }

    public static RelatedItemContent fromSla(SlaContent sla) {
        return (RelatedItemContent)RelatedItemContent.builder().sla(sla).build();
    }

    public static RelatedItemContent fromSla(Consumer<SlaContent.Builder> sla) {
        SlaContent.Builder builder = SlaContent.builder();
        sla.accept(builder);
        return RelatedItemContent.fromSla((SlaContent)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("comment", COMMENT_FIELD);
        map.put("contact", CONTACT_FIELD);
        map.put("file", FILE_FIELD);
        map.put("sla", SLA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedItemContent, T> g) {
        return obj -> g.apply((RelatedItemContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        COMMENT,
        CONTACT,
        FILE,
        SLA,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CommentContent comment;
        private ContactContent contact;
        private FileContent file;
        private SlaContent sla;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedItemContent model) {
            this.comment(model.comment);
            this.contact(model.contact);
            this.file(model.file);
            this.sla(model.sla);
        }

        public final CommentContent.Builder getComment() {
            return this.comment != null ? this.comment.toBuilder() : null;
        }

        public final void setComment(CommentContent.BuilderImpl comment) {
            CommentContent oldValue = this.comment;
            this.comment = comment != null ? comment.build() : null;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
        }

        @Override
        public final Builder comment(CommentContent comment) {
            CommentContent oldValue = this.comment;
            this.comment = comment;
            this.handleUnionValueChange(Type.COMMENT, oldValue, this.comment);
            return this;
        }

        public final ContactContent.Builder getContact() {
            return this.contact != null ? this.contact.toBuilder() : null;
        }

        public final void setContact(ContactContent.BuilderImpl contact) {
            ContactContent oldValue = this.contact;
            this.contact = contact != null ? contact.build() : null;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
        }

        @Override
        public final Builder contact(ContactContent contact) {
            ContactContent oldValue = this.contact;
            this.contact = contact;
            this.handleUnionValueChange(Type.CONTACT, oldValue, this.contact);
            return this;
        }

        public final FileContent.Builder getFile() {
            return this.file != null ? this.file.toBuilder() : null;
        }

        public final void setFile(FileContent.BuilderImpl file) {
            FileContent oldValue = this.file;
            this.file = file != null ? file.build() : null;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
        }

        @Override
        public final Builder file(FileContent file) {
            FileContent oldValue = this.file;
            this.file = file;
            this.handleUnionValueChange(Type.FILE, oldValue, this.file);
            return this;
        }

        public final SlaContent.Builder getSla() {
            return this.sla != null ? this.sla.toBuilder() : null;
        }

        public final void setSla(SlaContent.BuilderImpl sla) {
            SlaContent oldValue = this.sla;
            this.sla = sla != null ? sla.build() : null;
            this.handleUnionValueChange(Type.SLA, oldValue, this.sla);
        }

        @Override
        public final Builder sla(SlaContent sla) {
            SlaContent oldValue = this.sla;
            this.sla = sla;
            this.handleUnionValueChange(Type.SLA, oldValue, this.sla);
            return this;
        }

        public RelatedItemContent build() {
            return new RelatedItemContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedItemContent> {
        public Builder comment(CommentContent var1);

        default public Builder comment(Consumer<CommentContent.Builder> comment) {
            return this.comment((CommentContent)((CommentContent.Builder)CommentContent.builder().applyMutation(comment)).build());
        }

        public Builder contact(ContactContent var1);

        default public Builder contact(Consumer<ContactContent.Builder> contact) {
            return this.contact((ContactContent)((ContactContent.Builder)ContactContent.builder().applyMutation(contact)).build());
        }

        public Builder file(FileContent var1);

        default public Builder file(Consumer<FileContent.Builder> file) {
            return this.file((FileContent)((FileContent.Builder)FileContent.builder().applyMutation(file)).build());
        }

        public Builder sla(SlaContent var1);

        default public Builder sla(Consumer<SlaContent.Builder> sla) {
            return this.sla((SlaContent)((SlaContent.Builder)SlaContent.builder().applyMutation(sla)).build());
        }
    }
}

