/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcases.model.CommentBodyTextType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CommentContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CommentContent> {
    private static final SdkField<String> BODY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("body").getter(CommentContent.getter(CommentContent::body)).setter(CommentContent.setter(Builder::body)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("body").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(CommentContent.getter(CommentContent::contentTypeAsString)).setter(CommentContent.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BODY_FIELD, CONTENT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CommentContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String body;
    private final String contentType;

    private CommentContent(BuilderImpl builder) {
        this.body = builder.body;
        this.contentType = builder.contentType;
    }

    public final String body() {
        return this.body;
    }

    public final CommentBodyTextType contentType() {
        return CommentBodyTextType.fromValue(this.contentType);
    }

    public final String contentTypeAsString() {
        return this.contentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.body());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommentContent)) {
            return false;
        }
        CommentContent other = (CommentContent)obj;
        return Objects.equals(this.body(), other.body()) && Objects.equals(this.contentTypeAsString(), other.contentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CommentContent").add("Body", (Object)this.body()).add("ContentType", (Object)this.contentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "body": {
                return Optional.ofNullable(clazz.cast(this.body()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("body", BODY_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommentContent, T> g) {
        return obj -> g.apply((CommentContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String body;
        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(CommentContent model) {
            this.body(model.body);
            this.contentType(model.contentType);
        }

        public final String getBody() {
            return this.body;
        }

        public final void setBody(String body) {
            this.body = body;
        }

        @Override
        public final Builder body(String body) {
            this.body = body;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(CommentBodyTextType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public CommentContent build() {
            return new CommentContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CommentContent> {
        public Builder body(String var1);

        public Builder contentType(String var1);

        public Builder contentType(CommentBodyTextType var1);
    }
}

