/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.AuditEvent;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.GetCaseAuditEventsResponseAuditEventsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCaseAuditEventsResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, GetCaseAuditEventsResponse> {
    private static final SdkField<List<AuditEvent>> AUDIT_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("auditEvents").getter(GetCaseAuditEventsResponse.getter(GetCaseAuditEventsResponse::auditEvents)).setter(GetCaseAuditEventsResponse.setter(Builder::auditEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("auditEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetCaseAuditEventsResponse.getter(GetCaseAuditEventsResponse::nextToken)).setter(GetCaseAuditEventsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_EVENTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCaseAuditEventsResponse.memberNameToFieldInitializer();
    private final List<AuditEvent> auditEvents;
    private final String nextToken;

    private GetCaseAuditEventsResponse(BuilderImpl builder) {
        super(builder);
        this.auditEvents = builder.auditEvents;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuditEvents() {
        return this.auditEvents != null && !(this.auditEvents instanceof SdkAutoConstructList);
    }

    public final List<AuditEvent> auditEvents() {
        return this.auditEvents;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuditEvents() ? this.auditEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseAuditEventsResponse)) {
            return false;
        }
        GetCaseAuditEventsResponse other = (GetCaseAuditEventsResponse)((Object)obj);
        return this.hasAuditEvents() == other.hasAuditEvents() && Objects.equals(this.auditEvents(), other.auditEvents()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetCaseAuditEventsResponse").add("AuditEvents", this.hasAuditEvents() ? this.auditEvents() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "auditEvents": {
                return Optional.ofNullable(clazz.cast(this.auditEvents()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auditEvents", AUDIT_EVENTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCaseAuditEventsResponse, T> g) {
        return obj -> g.apply((GetCaseAuditEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private List<AuditEvent> auditEvents = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseAuditEventsResponse model) {
            super(model);
            this.auditEvents(model.auditEvents);
            this.nextToken(model.nextToken);
        }

        public final List<AuditEvent.Builder> getAuditEvents() {
            List<AuditEvent.Builder> result = GetCaseAuditEventsResponseAuditEventsListCopier.copyToBuilder(this.auditEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuditEvents(Collection<AuditEvent.BuilderImpl> auditEvents) {
            this.auditEvents = GetCaseAuditEventsResponseAuditEventsListCopier.copyFromBuilder(auditEvents);
        }

        @Override
        public final Builder auditEvents(Collection<AuditEvent> auditEvents) {
            this.auditEvents = GetCaseAuditEventsResponseAuditEventsListCopier.copy(auditEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(AuditEvent ... auditEvents) {
            this.auditEvents(Arrays.asList(auditEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder auditEvents(Consumer<AuditEvent.Builder> ... auditEvents) {
            this.auditEvents(Stream.of(auditEvents).map(c -> (AuditEvent)((AuditEvent.Builder)AuditEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCaseAuditEventsResponse build() {
            return new GetCaseAuditEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCaseAuditEventsResponse> {
        public Builder auditEvents(Collection<AuditEvent> var1);

        public Builder auditEvents(AuditEvent ... var1);

        public Builder auditEvents(Consumer<AuditEvent.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

