/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.AuditEventField;
import software.amazon.awssdk.services.connectcases.model.AuditEventFieldListCopier;
import software.amazon.awssdk.services.connectcases.model.AuditEventPerformedBy;
import software.amazon.awssdk.services.connectcases.model.AuditEventType;
import software.amazon.awssdk.services.connectcases.model.RelatedItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuditEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuditEvent> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(AuditEvent.getter(AuditEvent::eventId)).setter(AuditEvent.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<List<AuditEventField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fields").getter(AuditEvent.getter(AuditEvent::fields)).setter(AuditEvent.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditEventField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AuditEventPerformedBy> PERFORMED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performedBy").getter(AuditEvent.getter(AuditEvent::performedBy)).setter(AuditEvent.setter(Builder::performedBy)).constructor(AuditEventPerformedBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedBy").build()}).build();
    private static final SdkField<Instant> PERFORMED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("performedTime").getter(AuditEvent.getter(AuditEvent::performedTime)).setter(AuditEvent.setter(Builder::performedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performedTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> RELATED_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("relatedItemType").getter(AuditEvent.getter(AuditEvent::relatedItemTypeAsString)).setter(AuditEvent.setter(Builder::relatedItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relatedItemType").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AuditEvent.getter(AuditEvent::typeAsString)).setter(AuditEvent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, FIELDS_FIELD, PERFORMED_BY_FIELD, PERFORMED_TIME_FIELD, RELATED_ITEM_TYPE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventId", EVENT_ID_FIELD);
            this.put("fields", FIELDS_FIELD);
            this.put("performedBy", PERFORMED_BY_FIELD);
            this.put("performedTime", PERFORMED_TIME_FIELD);
            this.put("relatedItemType", RELATED_ITEM_TYPE_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final List<AuditEventField> fields;
    private final AuditEventPerformedBy performedBy;
    private final Instant performedTime;
    private final String relatedItemType;
    private final String type;

    private AuditEvent(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.fields = builder.fields;
        this.performedBy = builder.performedBy;
        this.performedTime = builder.performedTime;
        this.relatedItemType = builder.relatedItemType;
        this.type = builder.type;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructList);
    }

    public final List<AuditEventField> fields() {
        return this.fields;
    }

    public final AuditEventPerformedBy performedBy() {
        return this.performedBy;
    }

    public final Instant performedTime() {
        return this.performedTime;
    }

    public final RelatedItemType relatedItemType() {
        return RelatedItemType.fromValue(this.relatedItemType);
    }

    public final String relatedItemTypeAsString() {
        return this.relatedItemType;
    }

    public final AuditEventType type() {
        return AuditEventType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.performedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.performedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.relatedItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEvent)) {
            return false;
        }
        AuditEvent other = (AuditEvent)obj;
        return Objects.equals(this.eventId(), other.eventId()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && Objects.equals(this.performedBy(), other.performedBy()) && Objects.equals(this.performedTime(), other.performedTime()) && Objects.equals(this.relatedItemTypeAsString(), other.relatedItemTypeAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AuditEvent").add("EventId", (Object)this.eventId()).add("Fields", this.hasFields() ? this.fields() : null).add("PerformedBy", (Object)this.performedBy()).add("PerformedTime", (Object)this.performedTime()).add("RelatedItemType", (Object)this.relatedItemTypeAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "performedBy": {
                return Optional.ofNullable(clazz.cast(this.performedBy()));
            }
            case "performedTime": {
                return Optional.ofNullable(clazz.cast(this.performedTime()));
            }
            case "relatedItemType": {
                return Optional.ofNullable(clazz.cast(this.relatedItemTypeAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuditEvent, T> g) {
        return obj -> g.apply((AuditEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private List<AuditEventField> fields = DefaultSdkAutoConstructList.getInstance();
        private AuditEventPerformedBy performedBy;
        private Instant performedTime;
        private String relatedItemType;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditEvent model) {
            this.eventId(model.eventId);
            this.fields(model.fields);
            this.performedBy(model.performedBy);
            this.performedTime(model.performedTime);
            this.relatedItemType(model.relatedItemType);
            this.type(model.type);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final List<AuditEventField.Builder> getFields() {
            List<AuditEventField.Builder> result = AuditEventFieldListCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFields(Collection<AuditEventField.BuilderImpl> fields) {
            this.fields = AuditEventFieldListCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Collection<AuditEventField> fields) {
            this.fields = AuditEventFieldListCopier.copy(fields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(AuditEventField ... fields) {
            this.fields(Arrays.asList(fields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fields(Consumer<AuditEventField.Builder> ... fields) {
            this.fields(Stream.of(fields).map(c -> (AuditEventField)((AuditEventField.Builder)AuditEventField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AuditEventPerformedBy.Builder getPerformedBy() {
            return this.performedBy != null ? this.performedBy.toBuilder() : null;
        }

        public final void setPerformedBy(AuditEventPerformedBy.BuilderImpl performedBy) {
            this.performedBy = performedBy != null ? performedBy.build() : null;
        }

        @Override
        public final Builder performedBy(AuditEventPerformedBy performedBy) {
            this.performedBy = performedBy;
            return this;
        }

        public final Instant getPerformedTime() {
            return this.performedTime;
        }

        public final void setPerformedTime(Instant performedTime) {
            this.performedTime = performedTime;
        }

        @Override
        public final Builder performedTime(Instant performedTime) {
            this.performedTime = performedTime;
            return this;
        }

        public final String getRelatedItemType() {
            return this.relatedItemType;
        }

        public final void setRelatedItemType(String relatedItemType) {
            this.relatedItemType = relatedItemType;
        }

        @Override
        public final Builder relatedItemType(String relatedItemType) {
            this.relatedItemType = relatedItemType;
            return this;
        }

        @Override
        public final Builder relatedItemType(RelatedItemType relatedItemType) {
            this.relatedItemType(relatedItemType == null ? null : relatedItemType.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AuditEventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public AuditEvent build() {
            return new AuditEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuditEvent> {
        public Builder eventId(String var1);

        public Builder fields(Collection<AuditEventField> var1);

        public Builder fields(AuditEventField ... var1);

        public Builder fields(Consumer<AuditEventField.Builder> ... var1);

        public Builder performedBy(AuditEventPerformedBy var1);

        default public Builder performedBy(Consumer<AuditEventPerformedBy.Builder> performedBy) {
            return this.performedBy((AuditEventPerformedBy)((AuditEventPerformedBy.Builder)AuditEventPerformedBy.builder().applyMutation(performedBy)).build());
        }

        public Builder performedTime(Instant var1);

        public Builder relatedItemType(String var1);

        public Builder relatedItemType(RelatedItemType var1);

        public Builder type(String var1);

        public Builder type(AuditEventType var1);
    }
}

