/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuditEventType {
    CASE_CREATED("Case.Created"),
    CASE_UPDATED("Case.Updated"),
    RELATED_ITEM_CREATED("RelatedItem.Created"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuditEventType> VALUE_MAP;
    private final String value;

    private AuditEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuditEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuditEventType> knownValues() {
        EnumSet<AuditEventType> knownValues = EnumSet.allOf(AuditEventType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuditEventType.class, AuditEventType::toString);
    }
}

