/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClientBuilder;
import software.amazon.awssdk.services.connectcases.ConnectCasesServiceClientConfiguration;
import software.amazon.awssdk.services.connectcases.DefaultConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.DefaultConnectCasesBaseClientBuilder;
import software.amazon.awssdk.services.connectcases.endpoints.ConnectCasesEndpointProvider;

@SdkInternalApi
final class DefaultConnectCasesAsyncClientBuilder
extends DefaultConnectCasesBaseClientBuilder<ConnectCasesAsyncClientBuilder, ConnectCasesAsyncClient>
implements ConnectCasesAsyncClientBuilder {
    DefaultConnectCasesAsyncClientBuilder() {
    }

    @Override
    public DefaultConnectCasesAsyncClientBuilder endpointProvider(ConnectCasesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ConnectCasesAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultConnectCasesAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ConnectCasesServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultConnectCasesAsyncClient client = new DefaultConnectCasesAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ConnectCasesServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ConnectCasesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

