/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.connectcases.model.BatchGetFieldRequest;
import software.amazon.awssdk.services.connectcases.model.BatchGetFieldResponse;
import software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsRequest;
import software.amazon.awssdk.services.connectcases.model.BatchPutFieldOptionsResponse;
import software.amazon.awssdk.services.connectcases.model.CreateCaseRequest;
import software.amazon.awssdk.services.connectcases.model.CreateCaseResponse;
import software.amazon.awssdk.services.connectcases.model.CreateDomainRequest;
import software.amazon.awssdk.services.connectcases.model.CreateDomainResponse;
import software.amazon.awssdk.services.connectcases.model.CreateFieldRequest;
import software.amazon.awssdk.services.connectcases.model.CreateFieldResponse;
import software.amazon.awssdk.services.connectcases.model.CreateLayoutRequest;
import software.amazon.awssdk.services.connectcases.model.CreateLayoutResponse;
import software.amazon.awssdk.services.connectcases.model.CreateRelatedItemRequest;
import software.amazon.awssdk.services.connectcases.model.CreateRelatedItemResponse;
import software.amazon.awssdk.services.connectcases.model.CreateTemplateRequest;
import software.amazon.awssdk.services.connectcases.model.CreateTemplateResponse;
import software.amazon.awssdk.services.connectcases.model.DeleteDomainRequest;
import software.amazon.awssdk.services.connectcases.model.DeleteDomainResponse;
import software.amazon.awssdk.services.connectcases.model.GetCaseEventConfigurationRequest;
import software.amazon.awssdk.services.connectcases.model.GetCaseEventConfigurationResponse;
import software.amazon.awssdk.services.connectcases.model.GetCaseRequest;
import software.amazon.awssdk.services.connectcases.model.GetCaseResponse;
import software.amazon.awssdk.services.connectcases.model.GetDomainRequest;
import software.amazon.awssdk.services.connectcases.model.GetDomainResponse;
import software.amazon.awssdk.services.connectcases.model.GetLayoutRequest;
import software.amazon.awssdk.services.connectcases.model.GetLayoutResponse;
import software.amazon.awssdk.services.connectcases.model.GetTemplateRequest;
import software.amazon.awssdk.services.connectcases.model.GetTemplateResponse;
import software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest;
import software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponse;
import software.amazon.awssdk.services.connectcases.model.ListDomainsRequest;
import software.amazon.awssdk.services.connectcases.model.ListDomainsResponse;
import software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest;
import software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse;
import software.amazon.awssdk.services.connectcases.model.ListFieldsRequest;
import software.amazon.awssdk.services.connectcases.model.ListFieldsResponse;
import software.amazon.awssdk.services.connectcases.model.ListLayoutsRequest;
import software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse;
import software.amazon.awssdk.services.connectcases.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.connectcases.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest;
import software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse;
import software.amazon.awssdk.services.connectcases.model.PutCaseEventConfigurationRequest;
import software.amazon.awssdk.services.connectcases.model.PutCaseEventConfigurationResponse;
import software.amazon.awssdk.services.connectcases.model.SearchCasesRequest;
import software.amazon.awssdk.services.connectcases.model.SearchCasesResponse;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse;
import software.amazon.awssdk.services.connectcases.model.TagResourceRequest;
import software.amazon.awssdk.services.connectcases.model.TagResourceResponse;
import software.amazon.awssdk.services.connectcases.model.UntagResourceRequest;
import software.amazon.awssdk.services.connectcases.model.UntagResourceResponse;
import software.amazon.awssdk.services.connectcases.model.UpdateCaseRequest;
import software.amazon.awssdk.services.connectcases.model.UpdateCaseResponse;
import software.amazon.awssdk.services.connectcases.model.UpdateFieldRequest;
import software.amazon.awssdk.services.connectcases.model.UpdateFieldResponse;
import software.amazon.awssdk.services.connectcases.model.UpdateLayoutRequest;
import software.amazon.awssdk.services.connectcases.model.UpdateLayoutResponse;
import software.amazon.awssdk.services.connectcases.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.connectcases.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.connectcases.paginators.GetCasePublisher;
import software.amazon.awssdk.services.connectcases.paginators.ListCasesForContactPublisher;
import software.amazon.awssdk.services.connectcases.paginators.ListDomainsPublisher;
import software.amazon.awssdk.services.connectcases.paginators.ListFieldOptionsPublisher;
import software.amazon.awssdk.services.connectcases.paginators.ListFieldsPublisher;
import software.amazon.awssdk.services.connectcases.paginators.ListLayoutsPublisher;
import software.amazon.awssdk.services.connectcases.paginators.ListTemplatesPublisher;
import software.amazon.awssdk.services.connectcases.paginators.SearchCasesPublisher;
import software.amazon.awssdk.services.connectcases.paginators.SearchRelatedItemsPublisher;

/**
 * Service client for accessing ConnectCases asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * With Amazon Connect Cases, your agents can track and manage customer issues that require multiple interactions,
 * follow-up tasks, and teams in your contact center. A case represents a customer issue. It records the issue, the
 * steps and interactions taken to resolve the issue, and the outcome. For more information, see <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/cases.html">Amazon Connect Cases</a> in the <i>Amazon
 * Connect Administrator Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ConnectCasesAsyncClient extends AwsClient {
    String SERVICE_NAME = "cases";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "cases";

    /**
     * <p>
     * Returns the description for the list of fields in the request parameters.
     * </p>
     *
     * @param batchGetFieldRequest
     * @return A Java Future containing the result of the BatchGetField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.BatchGetField
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchGetField" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetFieldResponse> batchGetField(BatchGetFieldRequest batchGetFieldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the description for the list of fields in the request parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetFieldRequest.Builder} avoiding the need to
     * create one manually via {@link BatchGetFieldRequest#builder()}
     * </p>
     *
     * @param batchGetFieldRequest
     *        A {@link Consumer} that will call methods on {@link BatchGetFieldRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchGetField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.BatchGetField
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchGetField" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<BatchGetFieldResponse> batchGetField(Consumer<BatchGetFieldRequest.Builder> batchGetFieldRequest) {
        return batchGetField(BatchGetFieldRequest.builder().applyMutation(batchGetFieldRequest).build());
    }

    /**
     * <p>
     * Creates and updates a set of field options for a single select field in a Cases domain.
     * </p>
     *
     * @param batchPutFieldOptionsRequest
     * @return A Java Future containing the result of the BatchPutFieldOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.BatchPutFieldOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchPutFieldOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutFieldOptionsResponse> batchPutFieldOptions(
            BatchPutFieldOptionsRequest batchPutFieldOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates and updates a set of field options for a single select field in a Cases domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchPutFieldOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchPutFieldOptionsRequest#builder()}
     * </p>
     *
     * @param batchPutFieldOptionsRequest
     *        A {@link Consumer} that will call methods on {@link BatchPutFieldOptionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchPutFieldOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.BatchPutFieldOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/BatchPutFieldOptions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchPutFieldOptionsResponse> batchPutFieldOptions(
            Consumer<BatchPutFieldOptionsRequest.Builder> batchPutFieldOptionsRequest) {
        return batchPutFieldOptions(BatchPutFieldOptionsRequest.builder().applyMutation(batchPutFieldOptionsRequest).build());
    }

    /**
     * <p>
     * Creates a case in the specified Cases domain. Case system and custom fields are taken as an array id/value pairs
     * with a declared data types.
     * </p>
     * <note>
     * <p>
     * The following fields are required when creating a case:
     * </p>
     * 
     * <pre>
     * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;customer_id&lt;/code&gt; - You must provide the full customer profile ARN in this format: &lt;code&gt;arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain name/profiles/profile ID&lt;/code&gt; &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;title&lt;/code&gt; &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code>
     * </pre>
     *
     * @param createCaseRequest
     * @return A Java Future containing the result of the CreateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCaseResponse> createCase(CreateCaseRequest createCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a case in the specified Cases domain. Case system and custom fields are taken as an array id/value pairs
     * with a declared data types.
     * </p>
     * <note>
     * <p>
     * The following fields are required when creating a case:
     * </p>
     * 
     * <pre>
     * <code> &lt;ul&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;customer_id&lt;/code&gt; - You must provide the full customer profile ARN in this format: &lt;code&gt;arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain name/profiles/profile ID&lt;/code&gt; &lt;/p&gt; &lt;/li&gt; &lt;li&gt; &lt;p&gt; &lt;code&gt;title&lt;/code&gt; &lt;/p&gt; &lt;/li&gt; &lt;/ul&gt; &lt;/note&gt; </code>
     * </pre>
     * 
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateCaseRequest#builder()}
     * </p>
     *
     * @param createCaseRequest
     *        A {@link Consumer} that will call methods on {@link CreateCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateCaseResponse> createCase(Consumer<CreateCaseRequest.Builder> createCaseRequest) {
        return createCase(CreateCaseRequest.builder().applyMutation(createCaseRequest).build());
    }

    /**
     * <p>
     * Creates a domain, which is a container for all case data, such as cases, fields, templates and layouts. Each
     * Amazon Connect instance can be associated with only one Cases domain.
     * </p>
     * <important>
     * <p>
     * This will not associate your connect instance to Cases domain. Instead, use the Amazon Connect <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateIntegrationAssociation.html"
     * >CreateIntegrationAssociation</a> API. You need specific IAM permissions to successfully associate the Cases
     * domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/required-permissions-iam-cases.html#onboard-cases-iam"
     * >Onboard to Cases</a>.
     * </p>
     * </important>
     *
     * @param createDomainRequest
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(CreateDomainRequest createDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain, which is a container for all case data, such as cases, fields, templates and layouts. Each
     * Amazon Connect instance can be associated with only one Cases domain.
     * </p>
     * <important>
     * <p>
     * This will not associate your connect instance to Cases domain. Instead, use the Amazon Connect <a
     * href="https://docs.aws.amazon.com/connect/latest/APIReference/API_CreateIntegrationAssociation.html"
     * >CreateIntegrationAssociation</a> API. You need specific IAM permissions to successfully associate the Cases
     * domain. For more information, see <a href=
     * "https://docs.aws.amazon.com/connect/latest/adminguide/required-permissions-iam-cases.html#onboard-cases-iam"
     * >Onboard to Cases</a>.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDomainResponse> createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest) {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates a field in the Cases domain. This field is used to define the case object model (that is, defines what
     * data can be captured on cases) in a Cases domain.
     * </p>
     *
     * @param createFieldRequest
     * @return A Java Future containing the result of the CreateField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateField
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateField" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFieldResponse> createField(CreateFieldRequest createFieldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a field in the Cases domain. This field is used to define the case object model (that is, defines what
     * data can be captured on cases) in a Cases domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFieldRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFieldRequest#builder()}
     * </p>
     *
     * @param createFieldRequest
     *        A {@link Consumer} that will call methods on {@link CreateFieldRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateField
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateField" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateFieldResponse> createField(Consumer<CreateFieldRequest.Builder> createFieldRequest) {
        return createField(CreateFieldRequest.builder().applyMutation(createFieldRequest).build());
    }

    /**
     * <p>
     * Creates a layout in the Cases domain. Layouts define the following configuration in the top section and More Info
     * tab of the Cases user interface:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Fields to display to the users
     * </p>
     * </li>
     * <li>
     * <p>
     * Field ordering
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Title and Status fields cannot be part of layouts since they are not configurable.
     * </p>
     * </note>
     *
     * @param createLayoutRequest
     * @return A Java Future containing the result of the CreateLayout operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateLayout" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLayoutResponse> createLayout(CreateLayoutRequest createLayoutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a layout in the Cases domain. Layouts define the following configuration in the top section and More Info
     * tab of the Cases user interface:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Fields to display to the users
     * </p>
     * </li>
     * <li>
     * <p>
     * Field ordering
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Title and Status fields cannot be part of layouts since they are not configurable.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLayoutRequest.Builder} avoiding the need to
     * create one manually via {@link CreateLayoutRequest#builder()}
     * </p>
     *
     * @param createLayoutRequest
     *        A {@link Consumer} that will call methods on {@link CreateLayoutRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLayout operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateLayout" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLayoutResponse> createLayout(Consumer<CreateLayoutRequest.Builder> createLayoutRequest) {
        return createLayout(CreateLayoutRequest.builder().applyMutation(createLayoutRequest).build());
    }

    /**
     * <p>
     * Creates a related item (comments, tasks, and contacts) and associates it with a case.
     * </p>
     * <note>
     * <p>
     * A Related Item is a resource that is associated with a case. It may or may not have an external identifier
     * linking it to an external resource (for example, a <code>contactArn</code>). All Related Items have their own
     * internal identifier, the <code>relatedItemArn</code>. Examples of related items include <code>comments</code> and
     * <code>contacts</code>.
     * </p>
     * </note>
     *
     * @param createRelatedItemRequest
     * @return A Java Future containing the result of the CreateRelatedItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateRelatedItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateRelatedItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRelatedItemResponse> createRelatedItem(CreateRelatedItemRequest createRelatedItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a related item (comments, tasks, and contacts) and associates it with a case.
     * </p>
     * <note>
     * <p>
     * A Related Item is a resource that is associated with a case. It may or may not have an external identifier
     * linking it to an external resource (for example, a <code>contactArn</code>). All Related Items have their own
     * internal identifier, the <code>relatedItemArn</code>. Examples of related items include <code>comments</code> and
     * <code>contacts</code>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRelatedItemRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRelatedItemRequest#builder()}
     * </p>
     *
     * @param createRelatedItemRequest
     *        A {@link Consumer} that will call methods on {@link CreateRelatedItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRelatedItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateRelatedItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateRelatedItem"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateRelatedItemResponse> createRelatedItem(
            Consumer<CreateRelatedItemRequest.Builder> createRelatedItemRequest) {
        return createRelatedItem(CreateRelatedItemRequest.builder().applyMutation(createRelatedItemRequest).build());
    }

    /**
     * <p>
     * Creates a template in the Cases domain. This template is used to define the case object model (that is, to define
     * what data can be captured on cases) in a Cases domain. A template must have a unique name within a domain, and it
     * must reference existing field IDs and layout IDs. Additionally, multiple fields with same IDs are not allowed
     * within the same Template. A template can be either Active or Inactive, as indicated by its status. Inactive
     * templates cannot be used to create cases.
     * </p>
     *
     * @param createTemplateRequest
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTemplateResponse> createTemplate(CreateTemplateRequest createTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a template in the Cases domain. This template is used to define the case object model (that is, to define
     * what data can be captured on cases) in a Cases domain. A template must have a unique name within a domain, and it
     * must reference existing field IDs and layout IDs. Additionally, multiple fields with same IDs are not allowed
     * within the same Template. A template can be either Active or Inactive, as indicated by its status. Inactive
     * templates cannot be used to create cases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTemplateRequest#builder()}
     * </p>
     *
     * @param createTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/CreateTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateTemplateResponse> createTemplate(Consumer<CreateTemplateRequest.Builder> createTemplateRequest) {
        return createTemplate(CreateTemplateRequest.builder().applyMutation(createTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a domain.
     * </p>
     *
     * @param deleteDomainRequest
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(DeleteDomainRequest deleteDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/DeleteDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDomainResponse> deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest) {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific case if it exists.
     * </p>
     *
     * @param getCaseRequest
     * @return A Java Future containing the result of the GetCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCaseResponse> getCase(GetCaseRequest getCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific case if it exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseRequest.Builder} avoiding the need to create
     * one manually via {@link GetCaseRequest#builder()}
     * </p>
     *
     * @param getCaseRequest
     *        A {@link Consumer} that will call methods on {@link GetCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCaseResponse> getCase(Consumer<GetCaseRequest.Builder> getCaseRequest) {
        return getCase(GetCaseRequest.builder().applyMutation(getCaseRequest).build());
    }

    /**
     * <p>
     * Returns the case event publishing configuration.
     * </p>
     *
     * @param getCaseEventConfigurationRequest
     * @return A Java Future containing the result of the GetCaseEventConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetCaseEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCaseEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCaseEventConfigurationResponse> getCaseEventConfiguration(
            GetCaseEventConfigurationRequest getCaseEventConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the case event publishing configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseEventConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetCaseEventConfigurationRequest#builder()}
     * </p>
     *
     * @param getCaseEventConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetCaseEventConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCaseEventConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetCaseEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCaseEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetCaseEventConfigurationResponse> getCaseEventConfiguration(
            Consumer<GetCaseEventConfigurationRequest.Builder> getCaseEventConfigurationRequest) {
        return getCaseEventConfiguration(GetCaseEventConfigurationRequest.builder()
                .applyMutation(getCaseEventConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific case if it exists.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getCase(software.amazon.awssdk.services.connectcases.model.GetCaseRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.GetCasePublisher publisher = client.getCasePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.GetCasePublisher publisher = client.getCasePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.GetCaseResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.GetCaseResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCase(software.amazon.awssdk.services.connectcases.model.GetCaseRequest)} operation.</b>
     * </p>
     *
     * @param getCaseRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCasePublisher getCasePaginator(GetCaseRequest getCaseRequest) {
        return new GetCasePublisher(this, getCaseRequest);
    }

    /**
     * <p>
     * Returns information about a specific case if it exists.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getCase(software.amazon.awssdk.services.connectcases.model.GetCaseRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.GetCasePublisher publisher = client.getCasePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.GetCasePublisher publisher = client.getCasePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.GetCaseResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.GetCaseResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of null won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getCase(software.amazon.awssdk.services.connectcases.model.GetCaseRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCaseRequest.Builder} avoiding the need to create
     * one manually via {@link GetCaseRequest#builder()}
     * </p>
     *
     * @param getCaseRequest
     *        A {@link Consumer} that will call methods on {@link GetCaseRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCasePublisher getCasePaginator(Consumer<GetCaseRequest.Builder> getCaseRequest) {
        return getCasePaginator(GetCaseRequest.builder().applyMutation(getCaseRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific domain if it exists.
     * </p>
     *
     * @param getDomainRequest
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(GetDomainRequest getDomainRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific domain if it exists.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDomain operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetDomain" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDomainResponse> getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Returns the details for the requested layout.
     * </p>
     *
     * @param getLayoutRequest
     * @return A Java Future containing the result of the GetLayout operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetLayout" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLayoutResponse> getLayout(GetLayoutRequest getLayoutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the requested layout.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLayoutRequest.Builder} avoiding the need to
     * create one manually via {@link GetLayoutRequest#builder()}
     * </p>
     *
     * @param getLayoutRequest
     *        A {@link Consumer} that will call methods on {@link GetLayoutRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLayout operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetLayout" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLayoutResponse> getLayout(Consumer<GetLayoutRequest.Builder> getLayoutRequest) {
        return getLayout(GetLayoutRequest.builder().applyMutation(getLayoutRequest).build());
    }

    /**
     * <p>
     * Returns the details for the requested template.
     * </p>
     *
     * @param getTemplateRequest
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(GetTemplateRequest getTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the requested template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link GetTemplateRequest#builder()}
     * </p>
     *
     * @param getTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.GetTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/GetTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTemplateResponse> getTemplate(Consumer<GetTemplateRequest.Builder> getTemplateRequest) {
        return getTemplate(GetTemplateRequest.builder().applyMutation(getTemplateRequest).build());
    }

    /**
     * <p>
     * Lists cases for a given contact.
     * </p>
     *
     * @param listCasesForContactRequest
     * @return A Java Future containing the result of the ListCasesForContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListCasesForContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListCasesForContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCasesForContactResponse> listCasesForContact(
            ListCasesForContactRequest listCasesForContactRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists cases for a given contact.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCasesForContactRequest.Builder} avoiding the
     * need to create one manually via {@link ListCasesForContactRequest#builder()}
     * </p>
     *
     * @param listCasesForContactRequest
     *        A {@link Consumer} that will call methods on {@link ListCasesForContactRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCasesForContact operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListCasesForContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListCasesForContact"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCasesForContactResponse> listCasesForContact(
            Consumer<ListCasesForContactRequest.Builder> listCasesForContactRequest) {
        return listCasesForContact(ListCasesForContactRequest.builder().applyMutation(listCasesForContactRequest).build());
    }

    /**
     * <p>
     * Lists cases for a given contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCasesForContact(software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListCasesForContactPublisher publisher = client.listCasesForContactPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListCasesForContactPublisher publisher = client.listCasesForContactPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCasesForContact(software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCasesForContactRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListCasesForContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListCasesForContact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCasesForContactPublisher listCasesForContactPaginator(ListCasesForContactRequest listCasesForContactRequest) {
        return new ListCasesForContactPublisher(this, listCasesForContactRequest);
    }

    /**
     * <p>
     * Lists cases for a given contact.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCasesForContact(software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListCasesForContactPublisher publisher = client.listCasesForContactPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListCasesForContactPublisher publisher = client.listCasesForContactPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCasesForContact(software.amazon.awssdk.services.connectcases.model.ListCasesForContactRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCasesForContactRequest.Builder} avoiding the
     * need to create one manually via {@link ListCasesForContactRequest#builder()}
     * </p>
     *
     * @param listCasesForContactRequest
     *        A {@link Consumer} that will call methods on {@link ListCasesForContactRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListCasesForContact
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListCasesForContact"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCasesForContactPublisher listCasesForContactPaginator(
            Consumer<ListCasesForContactRequest.Builder> listCasesForContactRequest) {
        return listCasesForContactPaginator(ListCasesForContactRequest.builder().applyMutation(listCasesForContactRequest)
                .build());
    }

    /**
     * <p>
     * Lists all cases domains in the Amazon Web Services account. Each list item is a condensed summary object of the
     * domain.
     * </p>
     *
     * @param listDomainsRequest
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(ListDomainsRequest listDomainsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all cases domains in the Amazon Web Services account. Each list item is a condensed summary object of the
     * domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDomains operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDomainsResponse> listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all cases domains in the Amazon Web Services account. Each list item is a condensed summary object of the
     * domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.connectcases.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.connectcases.model.ListDomainsRequest)} operation.</b>
     * </p>
     *
     * @param listDomainsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(ListDomainsRequest listDomainsRequest) {
        return new ListDomainsPublisher(this, listDomainsRequest);
    }

    /**
     * <p>
     * Lists all cases domains in the Amazon Web Services account. Each list item is a condensed summary object of the
     * domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDomains(software.amazon.awssdk.services.connectcases.model.ListDomainsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListDomainsPublisher publisher = client.listDomainsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListDomainsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListDomainsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomains(software.amazon.awssdk.services.connectcases.model.ListDomainsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListDomains" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainsPublisher listDomainsPaginator(Consumer<ListDomainsRequest.Builder> listDomainsRequest) {
        return listDomainsPaginator(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Lists all of the field options for a field identifier in the domain.
     * </p>
     *
     * @param listFieldOptionsRequest
     * @return A Java Future containing the result of the ListFieldOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFieldOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFieldOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFieldOptionsResponse> listFieldOptions(ListFieldOptionsRequest listFieldOptionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the field options for a field identifier in the domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListFieldOptionsRequest#builder()}
     * </p>
     *
     * @param listFieldOptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldOptionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFieldOptions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFieldOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFieldOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListFieldOptionsResponse> listFieldOptions(
            Consumer<ListFieldOptionsRequest.Builder> listFieldOptionsRequest) {
        return listFieldOptions(ListFieldOptionsRequest.builder().applyMutation(listFieldOptionsRequest).build());
    }

    /**
     * <p>
     * Lists all of the field options for a field identifier in the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFieldOptions(software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldOptionsPublisher publisher = client.listFieldOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldOptionsPublisher publisher = client.listFieldOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFieldOptions(software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFieldOptionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFieldOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFieldOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFieldOptionsPublisher listFieldOptionsPaginator(ListFieldOptionsRequest listFieldOptionsRequest) {
        return new ListFieldOptionsPublisher(this, listFieldOptionsRequest);
    }

    /**
     * <p>
     * Lists all of the field options for a field identifier in the domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFieldOptions(software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldOptionsPublisher publisher = client.listFieldOptionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldOptionsPublisher publisher = client.listFieldOptionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFieldOptions(software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListFieldOptionsRequest#builder()}
     * </p>
     *
     * @param listFieldOptionsRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldOptionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFieldOptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFieldOptions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListFieldOptionsPublisher listFieldOptionsPaginator(Consumer<ListFieldOptionsRequest.Builder> listFieldOptionsRequest) {
        return listFieldOptionsPaginator(ListFieldOptionsRequest.builder().applyMutation(listFieldOptionsRequest).build());
    }

    /**
     * <p>
     * Lists all fields in a Cases domain.
     * </p>
     *
     * @param listFieldsRequest
     * @return A Java Future containing the result of the ListFields operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFields
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFields" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFieldsResponse> listFields(ListFieldsRequest listFieldsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all fields in a Cases domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFieldsRequest#builder()}
     * </p>
     *
     * @param listFieldsRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListFields operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFields
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFields" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListFieldsResponse> listFields(Consumer<ListFieldsRequest.Builder> listFieldsRequest) {
        return listFields(ListFieldsRequest.builder().applyMutation(listFieldsRequest).build());
    }

    /**
     * <p>
     * Lists all fields in a Cases domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFields(software.amazon.awssdk.services.connectcases.model.ListFieldsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldsPublisher publisher = client.listFieldsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldsPublisher publisher = client.listFieldsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListFieldsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListFieldsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFields(software.amazon.awssdk.services.connectcases.model.ListFieldsRequest)} operation.</b>
     * </p>
     *
     * @param listFieldsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFields
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFields" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFieldsPublisher listFieldsPaginator(ListFieldsRequest listFieldsRequest) {
        return new ListFieldsPublisher(this, listFieldsRequest);
    }

    /**
     * <p>
     * Lists all fields in a Cases domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFields(software.amazon.awssdk.services.connectcases.model.ListFieldsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldsPublisher publisher = client.listFieldsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListFieldsPublisher publisher = client.listFieldsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListFieldsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListFieldsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFields(software.amazon.awssdk.services.connectcases.model.ListFieldsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFieldsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFieldsRequest#builder()}
     * </p>
     *
     * @param listFieldsRequest
     *        A {@link Consumer} that will call methods on {@link ListFieldsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListFields
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListFields" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFieldsPublisher listFieldsPaginator(Consumer<ListFieldsRequest.Builder> listFieldsRequest) {
        return listFieldsPaginator(ListFieldsRequest.builder().applyMutation(listFieldsRequest).build());
    }

    /**
     * <p>
     * Lists all layouts in the given cases domain. Each list item is a condensed summary object of the layout.
     * </p>
     *
     * @param listLayoutsRequest
     * @return A Java Future containing the result of the ListLayouts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListLayouts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayoutsResponse> listLayouts(ListLayoutsRequest listLayoutsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all layouts in the given cases domain. Each list item is a condensed summary object of the layout.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayoutsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayoutsRequest#builder()}
     * </p>
     *
     * @param listLayoutsRequest
     *        A {@link Consumer} that will call methods on {@link ListLayoutsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLayouts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListLayouts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLayoutsResponse> listLayouts(Consumer<ListLayoutsRequest.Builder> listLayoutsRequest) {
        return listLayouts(ListLayoutsRequest.builder().applyMutation(listLayoutsRequest).build());
    }

    /**
     * <p>
     * Lists all layouts in the given cases domain. Each list item is a condensed summary object of the layout.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLayouts(software.amazon.awssdk.services.connectcases.model.ListLayoutsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListLayoutsPublisher publisher = client.listLayoutsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListLayoutsPublisher publisher = client.listLayoutsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayouts(software.amazon.awssdk.services.connectcases.model.ListLayoutsRequest)} operation.</b>
     * </p>
     *
     * @param listLayoutsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListLayouts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayoutsPublisher listLayoutsPaginator(ListLayoutsRequest listLayoutsRequest) {
        return new ListLayoutsPublisher(this, listLayoutsRequest);
    }

    /**
     * <p>
     * Lists all layouts in the given cases domain. Each list item is a condensed summary object of the layout.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listLayouts(software.amazon.awssdk.services.connectcases.model.ListLayoutsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListLayoutsPublisher publisher = client.listLayoutsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListLayoutsPublisher publisher = client.listLayoutsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListLayoutsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLayouts(software.amazon.awssdk.services.connectcases.model.ListLayoutsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLayoutsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLayoutsRequest#builder()}
     * </p>
     *
     * @param listLayoutsRequest
     *        A {@link Consumer} that will call methods on {@link ListLayoutsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListLayouts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListLayouts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLayoutsPublisher listLayoutsPaginator(Consumer<ListLayoutsRequest.Builder> listLayoutsRequest) {
        return listLayoutsPaginator(ListLayoutsRequest.builder().applyMutation(listLayoutsRequest).build());
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all of the templates in a Cases domain. Each list item is a condensed summary object of the template.
     * </p>
     *
     * @param listTemplatesRequest
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the templates in a Cases domain. Each list item is a condensed summary object of the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTemplatesResponse> listTemplates(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest) {
        return listTemplates(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all of the templates in a Cases domain. Each list item is a condensed summary object of the template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplatesPublisher listTemplatesPaginator(ListTemplatesRequest listTemplatesRequest) {
        return new ListTemplatesPublisher(this, listTemplatesRequest);
    }

    /**
     * <p>
     * Lists all of the templates in a Cases domain. Each list item is a condensed summary object of the template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplatesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTemplatesRequest#builder()}
     * </p>
     *
     * @param listTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplatesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/ListTemplates" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTemplatesPublisher listTemplatesPaginator(Consumer<ListTemplatesRequest.Builder> listTemplatesRequest) {
        return listTemplatesPaginator(ListTemplatesRequest.builder().applyMutation(listTemplatesRequest).build());
    }

    /**
     * <p>
     * API for adding case event publishing configuration
     * </p>
     *
     * @param putCaseEventConfigurationRequest
     * @return A Java Future containing the result of the PutCaseEventConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.PutCaseEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/PutCaseEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutCaseEventConfigurationResponse> putCaseEventConfiguration(
            PutCaseEventConfigurationRequest putCaseEventConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * API for adding case event publishing configuration
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutCaseEventConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link PutCaseEventConfigurationRequest#builder()}
     * </p>
     *
     * @param putCaseEventConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link PutCaseEventConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutCaseEventConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.PutCaseEventConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/PutCaseEventConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutCaseEventConfigurationResponse> putCaseEventConfiguration(
            Consumer<PutCaseEventConfigurationRequest.Builder> putCaseEventConfigurationRequest) {
        return putCaseEventConfiguration(PutCaseEventConfigurationRequest.builder()
                .applyMutation(putCaseEventConfigurationRequest).build());
    }

    /**
     * <p>
     * Searches for cases within their associated Cases domain. Search results are returned as a paginated list of
     * abridged case documents.
     * </p>
     * <note>
     * <p>
     * For <code>customer_id</code> you must provide the full customer profile ARN in this format:
     * <code> arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain name/profiles/profile ID</code>
     * .
     * </p>
     * </note>
     *
     * @param searchCasesRequest
     * @return A Java Future containing the result of the SearchCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchCasesResponse> searchCases(SearchCasesRequest searchCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for cases within their associated Cases domain. Search results are returned as a paginated list of
     * abridged case documents.
     * </p>
     * <note>
     * <p>
     * For <code>customer_id</code> you must provide the full customer profile ARN in this format:
     * <code> arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain name/profiles/profile ID</code>
     * .
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchCasesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchCasesRequest#builder()}
     * </p>
     *
     * @param searchCasesRequest
     *        A {@link Consumer} that will call methods on {@link SearchCasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the SearchCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<SearchCasesResponse> searchCases(Consumer<SearchCasesRequest.Builder> searchCasesRequest) {
        return searchCases(SearchCasesRequest.builder().applyMutation(searchCasesRequest).build());
    }

    /**
     * <p>
     * Searches for cases within their associated Cases domain. Search results are returned as a paginated list of
     * abridged case documents.
     * </p>
     * <note>
     * <p>
     * For <code>customer_id</code> you must provide the full customer profile ARN in this format:
     * <code> arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain name/profiles/profile ID</code>
     * .
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #searchCases(software.amazon.awssdk.services.connectcases.model.SearchCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchCasesPublisher publisher = client.searchCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchCasesPublisher publisher = client.searchCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.SearchCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.SearchCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchCases(software.amazon.awssdk.services.connectcases.model.SearchCasesRequest)} operation.</b>
     * </p>
     *
     * @param searchCasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchCases" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchCasesPublisher searchCasesPaginator(SearchCasesRequest searchCasesRequest) {
        return new SearchCasesPublisher(this, searchCasesRequest);
    }

    /**
     * <p>
     * Searches for cases within their associated Cases domain. Search results are returned as a paginated list of
     * abridged case documents.
     * </p>
     * <note>
     * <p>
     * For <code>customer_id</code> you must provide the full customer profile ARN in this format:
     * <code> arn:aws:profile:your AWS Region:your AWS account ID:domains/profiles domain name/profiles/profile ID</code>
     * .
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #searchCases(software.amazon.awssdk.services.connectcases.model.SearchCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchCasesPublisher publisher = client.searchCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchCasesPublisher publisher = client.searchCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.SearchCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.SearchCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchCases(software.amazon.awssdk.services.connectcases.model.SearchCasesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchCasesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchCasesRequest#builder()}
     * </p>
     *
     * @param searchCasesRequest
     *        A {@link Consumer} that will call methods on {@link SearchCasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchCases" target="_top">AWS API
     *      Documentation</a>
     */
    default SearchCasesPublisher searchCasesPaginator(Consumer<SearchCasesRequest.Builder> searchCasesRequest) {
        return searchCasesPaginator(SearchCasesRequest.builder().applyMutation(searchCasesRequest).build());
    }

    /**
     * <p>
     * Searches for related items that are associated with a case.
     * </p>
     * <note>
     * <p>
     * If no filters are provided, this returns all related items associated with a case.
     * </p>
     * </note>
     *
     * @param searchRelatedItemsRequest
     * @return A Java Future containing the result of the SearchRelatedItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchRelatedItemsResponse> searchRelatedItems(SearchRelatedItemsRequest searchRelatedItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for related items that are associated with a case.
     * </p>
     * <note>
     * <p>
     * If no filters are provided, this returns all related items associated with a case.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRelatedItemsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchRelatedItemsRequest#builder()}
     * </p>
     *
     * @param searchRelatedItemsRequest
     *        A {@link Consumer} that will call methods on {@link SearchRelatedItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the SearchRelatedItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<SearchRelatedItemsResponse> searchRelatedItems(
            Consumer<SearchRelatedItemsRequest.Builder> searchRelatedItemsRequest) {
        return searchRelatedItems(SearchRelatedItemsRequest.builder().applyMutation(searchRelatedItemsRequest).build());
    }

    /**
     * <p>
     * Searches for related items that are associated with a case.
     * </p>
     * <note>
     * <p>
     * If no filters are provided, this returns all related items associated with a case.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #searchRelatedItems(software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchRelatedItemsPublisher publisher = client.searchRelatedItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchRelatedItemsPublisher publisher = client.searchRelatedItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRelatedItems(software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchRelatedItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchRelatedItemsPublisher searchRelatedItemsPaginator(SearchRelatedItemsRequest searchRelatedItemsRequest) {
        return new SearchRelatedItemsPublisher(this, searchRelatedItemsRequest);
    }

    /**
     * <p>
     * Searches for related items that are associated with a case.
     * </p>
     * <note>
     * <p>
     * If no filters are provided, this returns all related items associated with a case.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #searchRelatedItems(software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchRelatedItemsPublisher publisher = client.searchRelatedItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.connectcases.paginators.SearchRelatedItemsPublisher publisher = client.searchRelatedItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchRelatedItems(software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchRelatedItemsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchRelatedItemsRequest#builder()}
     * </p>
     *
     * @param searchRelatedItemsRequest
     *        A {@link Consumer} that will call methods on {@link SearchRelatedItemsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.SearchRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/SearchRelatedItems"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchRelatedItemsPublisher searchRelatedItemsPaginator(
            Consumer<SearchRelatedItemsRequest.Builder> searchRelatedItemsRequest) {
        return searchRelatedItemsPaginator(SearchRelatedItemsRequest.builder().applyMutation(searchRelatedItemsRequest).build());
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the values of fields on a case. Fields to be updated are received as an array of id/value pairs identical
     * to the <code>CreateCase</code> input .
     * </p>
     * <p>
     * If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     *
     * @param updateCaseRequest
     * @return A Java Future containing the result of the UpdateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCaseResponse> updateCase(UpdateCaseRequest updateCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the values of fields on a case. Fields to be updated are received as an array of id/value pairs identical
     * to the <code>CreateCase</code> input .
     * </p>
     * <p>
     * If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCaseRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateCaseRequest#builder()}
     * </p>
     *
     * @param updateCaseRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateCaseResponse> updateCase(Consumer<UpdateCaseRequest.Builder> updateCaseRequest) {
        return updateCase(UpdateCaseRequest.builder().applyMutation(updateCaseRequest).build());
    }

    /**
     * <p>
     * Updates the properties of an existing field.
     * </p>
     *
     * @param updateFieldRequest
     * @return A Java Future containing the result of the UpdateField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateField
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateField" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFieldResponse> updateField(UpdateFieldRequest updateFieldRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of an existing field.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFieldRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFieldRequest#builder()}
     * </p>
     *
     * @param updateFieldRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFieldRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateField operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateField
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateField" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateFieldResponse> updateField(Consumer<UpdateFieldRequest.Builder> updateFieldRequest) {
        return updateField(UpdateFieldRequest.builder().applyMutation(updateFieldRequest).build());
    }

    /**
     * <p>
     * Updates the attributes of an existing layout.
     * </p>
     * <p>
     * If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <p>
     * A <code>ValidationException</code> is returned when you add non-existent <code>fieldIds</code> to a layout.
     * </p>
     * <note>
     * <p>
     * Title and Status fields cannot be part of layouts because they are not configurable.
     * </p>
     * </note>
     *
     * @param updateLayoutRequest
     * @return A Java Future containing the result of the UpdateLayout operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateLayout" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLayoutResponse> updateLayout(UpdateLayoutRequest updateLayoutRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the attributes of an existing layout.
     * </p>
     * <p>
     * If the action is successful, the service sends back an HTTP 200 response with an empty HTTP body.
     * </p>
     * <p>
     * A <code>ValidationException</code> is returned when you add non-existent <code>fieldIds</code> to a layout.
     * </p>
     * <note>
     * <p>
     * Title and Status fields cannot be part of layouts because they are not configurable.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLayoutRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateLayoutRequest#builder()}
     * </p>
     *
     * @param updateLayoutRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLayoutRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateLayout operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded. For a list of service quotas, see
     *         <a href="https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html">Amazon
     *         Connect Service Quotas</a> in the <i>Amazon Connect Administrator Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateLayout
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateLayout" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLayoutResponse> updateLayout(Consumer<UpdateLayoutRequest.Builder> updateLayoutRequest) {
        return updateLayout(UpdateLayoutRequest.builder().applyMutation(updateLayoutRequest).build());
    }

    /**
     * <p>
     * Updates the attributes of an existing template. The template attributes that can be modified include
     * <code>name</code>, <code>description</code>, <code>layoutConfiguration</code>, <code>requiredFields</code>, and
     * <code>status</code>. At least one of these attributes must not be null. If a null value is provided for a given
     * attribute, that attribute is ignored and its current value is preserved.
     * </p>
     *
     * @param updateTemplateRequest
     * @return A Java Future containing the result of the UpdateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateResponse> updateTemplate(UpdateTemplateRequest updateTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the attributes of an existing template. The template attributes that can be modified include
     * <code>name</code>, <code>description</code>, <code>layoutConfiguration</code>, <code>requiredFields</code>, and
     * <code>status</code>. At least one of these attributes must not be null. If a null value is provided for a given
     * attribute, that attribute is ignored and its current value is preserved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTemplateRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTemplateRequest#builder()}
     * </p>
     *
     * @param updateTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateTemplateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException We couldn't process your request because of an issue with the server. Try
     *         again later.</li>
     *         <li>ResourceNotFoundException We couldn't find the requested resource. Check that your resources exists
     *         and were created in the same Amazon Web Services Region as your request, and try your request again.</li>
     *         <li>ValidationException The request isn't valid. Check the syntax and try again.</li>
     *         <li>ThrottlingException The rate has been exceeded for this API. Please try again after a few minutes.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>ConflictException The requested operation would cause a conflict with the current state of a service
     *         resource associated with the request. Resolve the conflict before retrying this request. See the
     *         accompanying error message for details.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ConnectCasesException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ConnectCasesAsyncClient.UpdateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/connectcases-2022-10-03/UpdateTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateTemplateResponse> updateTemplate(Consumer<UpdateTemplateRequest.Builder> updateTemplateRequest) {
        return updateTemplate(UpdateTemplateRequest.builder().applyMutation(updateTemplateRequest).build());
    }

    @Override
    default ConnectCasesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ConnectCasesAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ConnectCasesAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ConnectCasesAsyncClient}.
     */
    static ConnectCasesAsyncClientBuilder builder() {
        return new DefaultConnectCasesAsyncClientBuilder();
    }
}
