/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.model.ListFieldOptionsRequest;
import software.amazon.awssdk.services.connectcases.model.ListFieldOptionsResponse;

public class ListFieldOptionsIterable
implements SdkIterable<ListFieldOptionsResponse> {
    private final ConnectCasesClient client;
    private final ListFieldOptionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFieldOptionsIterable(ConnectCasesClient client, ListFieldOptionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListFieldOptionsResponseFetcher();
    }

    public Iterator<ListFieldOptionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFieldOptionsResponseFetcher
    implements SyncPageFetcher<ListFieldOptionsResponse> {
        private ListFieldOptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListFieldOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFieldOptionsResponse nextPage(ListFieldOptionsResponse previousPage) {
            if (previousPage == null) {
                return ListFieldOptionsIterable.this.client.listFieldOptions(ListFieldOptionsIterable.this.firstRequest);
            }
            return ListFieldOptionsIterable.this.client.listFieldOptions((ListFieldOptionsRequest)((Object)ListFieldOptionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

