/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.ListTemplatesRequest;
import software.amazon.awssdk.services.connectcases.model.ListTemplatesResponse;

public class ListTemplatesPublisher
implements SdkPublisher<ListTemplatesResponse> {
    private final ConnectCasesAsyncClient client;
    private final ListTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTemplatesPublisher(ConnectCasesAsyncClient client, ListTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTemplatesPublisher(ConnectCasesAsyncClient client, ListTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTemplatesResponseFetcher
    implements AsyncPageFetcher<ListTemplatesResponse> {
        private ListTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTemplatesResponse> nextPage(ListTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplatesPublisher.this.client.listTemplates(ListTemplatesPublisher.this.firstRequest);
            }
            return ListTemplatesPublisher.this.client.listTemplates((ListTemplatesRequest)((Object)ListTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

