/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcases.model.SearchCasesRequest;
import software.amazon.awssdk.services.connectcases.model.SearchCasesResponse;
import software.amazon.awssdk.services.connectcases.model.SearchCasesResponseItem;

public class SearchCasesIterable
implements SdkIterable<SearchCasesResponse> {
    private final ConnectCasesClient client;
    private final SearchCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchCasesIterable(ConnectCasesClient client, SearchCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchCasesResponseFetcher();
    }

    public Iterator<SearchCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchCasesResponseItem> cases() {
        Function<SearchCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.cases() != null) {
                return response.cases().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchCasesResponseFetcher
    implements SyncPageFetcher<SearchCasesResponse> {
        private SearchCasesResponseFetcher() {
        }

        public boolean hasNextPage(SearchCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchCasesResponse nextPage(SearchCasesResponse previousPage) {
            if (previousPage == null) {
                return SearchCasesIterable.this.client.searchCases(SearchCasesIterable.this.firstRequest);
            }
            return SearchCasesIterable.this.client.searchCases((SearchCasesRequest)((Object)SearchCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

