/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcases.model.CaseSummary;
import software.amazon.awssdk.services.connectcases.model.ConnectCasesResponse;
import software.amazon.awssdk.services.connectcases.model.ListCasesForContactResponseCasesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCasesForContactResponse
extends ConnectCasesResponse
implements ToCopyableBuilder<Builder, ListCasesForContactResponse> {
    private static final SdkField<List<CaseSummary>> CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("cases").getter(ListCasesForContactResponse.getter(ListCasesForContactResponse::cases)).setter(ListCasesForContactResponse.setter(Builder::cases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cases").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaseSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCasesForContactResponse.getter(ListCasesForContactResponse::nextToken)).setter(ListCasesForContactResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CaseSummary> cases;
    private final String nextToken;

    private ListCasesForContactResponse(BuilderImpl builder) {
        super(builder);
        this.cases = builder.cases;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCases() {
        return this.cases != null && !(this.cases instanceof SdkAutoConstructList);
    }

    public final List<CaseSummary> cases() {
        return this.cases;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCases() ? this.cases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCasesForContactResponse)) {
            return false;
        }
        ListCasesForContactResponse other = (ListCasesForContactResponse)((Object)obj);
        return this.hasCases() == other.hasCases() && Objects.equals(this.cases(), other.cases()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCasesForContactResponse").add("Cases", this.hasCases() ? this.cases() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cases": {
                return Optional.ofNullable(clazz.cast(this.cases()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCasesForContactResponse, T> g) {
        return obj -> g.apply((ListCasesForContactResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCasesResponse.BuilderImpl
    implements Builder {
        private List<CaseSummary> cases = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCasesForContactResponse model) {
            super(model);
            this.cases(model.cases);
            this.nextToken(model.nextToken);
        }

        public final List<CaseSummary.Builder> getCases() {
            List<CaseSummary.Builder> result = ListCasesForContactResponseCasesListCopier.copyToBuilder(this.cases);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCases(Collection<CaseSummary.BuilderImpl> cases) {
            this.cases = ListCasesForContactResponseCasesListCopier.copyFromBuilder(cases);
        }

        @Override
        public final Builder cases(Collection<CaseSummary> cases) {
            this.cases = ListCasesForContactResponseCasesListCopier.copy(cases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(CaseSummary ... cases) {
            this.cases(Arrays.asList(cases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cases(Consumer<CaseSummary.Builder> ... cases) {
            this.cases(Stream.of(cases).map(c -> (CaseSummary)((CaseSummary.Builder)CaseSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCasesForContactResponse build() {
            return new ListCasesForContactResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ConnectCasesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCasesForContactResponse> {
        public Builder cases(Collection<CaseSummary> var1);

        public Builder cases(CaseSummary ... var1);

        public Builder cases(Consumer<CaseSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

