/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcases.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLayoutRequest extends ConnectCasesRequest implements
        ToCopyableBuilder<CreateLayoutRequest.Builder, CreateLayoutRequest> {
    private static final SdkField<LayoutContent> CONTENT_FIELD = SdkField.<LayoutContent> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(CreateLayoutRequest::content)).setter(setter(Builder::content))
            .constructor(LayoutContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainId").getter(getter(CreateLayoutRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateLayoutRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            DOMAIN_ID_FIELD, NAME_FIELD));

    private final LayoutContent content;

    private final String domainId;

    private final String name;

    private CreateLayoutRequest(BuilderImpl builder) {
        super(builder);
        this.content = builder.content;
        this.domainId = builder.domainId;
        this.name = builder.name;
    }

    /**
     * <p>
     * Information about which fields will be present in the layout, and information about the order of the fields.
     * </p>
     * 
     * @return Information about which fields will be present in the layout, and information about the order of the
     *         fields.
     */
    public final LayoutContent content() {
        return content;
    }

    /**
     * <p>
     * The unique identifier of the Cases domain.
     * </p>
     * 
     * @return The unique identifier of the Cases domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the layout. It must be unique for the Cases domain.
     * </p>
     * 
     * @return The name of the layout. It must be unique for the Cases domain.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLayoutRequest)) {
            return false;
        }
        CreateLayoutRequest other = (CreateLayoutRequest) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(domainId(), other.domainId())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLayoutRequest").add("Content", content()).add("DomainId", domainId()).add("Name", name())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "domainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLayoutRequest, T> g) {
        return obj -> g.apply((CreateLayoutRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCasesRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLayoutRequest> {
        /**
         * <p>
         * Information about which fields will be present in the layout, and information about the order of the fields.
         * </p>
         * 
         * @param content
         *        Information about which fields will be present in the layout, and information about the order of the
         *        fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(LayoutContent content);

        /**
         * <p>
         * Information about which fields will be present in the layout, and information about the order of the fields.
         * </p>
         * This is a convenience method that creates an instance of the {@link LayoutContent.Builder} avoiding the need
         * to create one manually via {@link LayoutContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LayoutContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(LayoutContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link LayoutContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(LayoutContent)
         */
        default Builder content(Consumer<LayoutContent.Builder> content) {
            return content(LayoutContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The unique identifier of the Cases domain.
         * </p>
         * 
         * @param domainId
         *        The unique identifier of the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the layout. It must be unique for the Cases domain.
         * </p>
         * 
         * @param name
         *        The name of the layout. It must be unique for the Cases domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCasesRequest.BuilderImpl implements Builder {
        private LayoutContent content;

        private String domainId;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLayoutRequest model) {
            super(model);
            content(model.content);
            domainId(model.domainId);
            name(model.name);
        }

        public final LayoutContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(LayoutContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(LayoutContent content) {
            this.content = content;
            return this;
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLayoutRequest build() {
            return new CreateLayoutRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
