/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.ConnectCasesClientBuilder;
import software.amazon.awssdk.services.connectcases.ConnectCasesServiceClientConfiguration;
import software.amazon.awssdk.services.connectcases.DefaultConnectCasesBaseClientBuilder;
import software.amazon.awssdk.services.connectcases.DefaultConnectCasesClient;
import software.amazon.awssdk.services.connectcases.endpoints.ConnectCasesEndpointProvider;

@SdkInternalApi
final class DefaultConnectCasesClientBuilder
extends DefaultConnectCasesBaseClientBuilder<ConnectCasesClientBuilder, ConnectCasesClient>
implements ConnectCasesClientBuilder {
    DefaultConnectCasesClientBuilder() {
    }

    @Override
    public DefaultConnectCasesClientBuilder endpointProvider(ConnectCasesEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ConnectCasesClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultConnectCasesClientBuilder.validateClientOptions(clientConfiguration);
        ConnectCasesServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultConnectCasesClient client = new DefaultConnectCasesClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ConnectCasesServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ConnectCasesServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

