/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.model.ListFieldsRequest;
import software.amazon.awssdk.services.connectcases.model.ListFieldsResponse;

public class ListFieldsPublisher
implements SdkPublisher<ListFieldsResponse> {
    private final ConnectCasesAsyncClient client;
    private final ListFieldsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFieldsPublisher(ConnectCasesAsyncClient client, ListFieldsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFieldsPublisher(ConnectCasesAsyncClient client, ListFieldsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFieldsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFieldsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListFieldsResponseFetcher
    implements AsyncPageFetcher<ListFieldsResponse> {
        private ListFieldsResponseFetcher() {
        }

        public boolean hasNextPage(ListFieldsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFieldsResponse> nextPage(ListFieldsResponse previousPage) {
            if (previousPage == null) {
                return ListFieldsPublisher.this.client.listFields(ListFieldsPublisher.this.firstRequest);
            }
            return ListFieldsPublisher.this.client.listFields((ListFieldsRequest)((Object)ListFieldsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

