/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesClient;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem;

public class SearchRelatedItemsIterable
implements SdkIterable<SearchRelatedItemsResponse> {
    private final ConnectCasesClient client;
    private final SearchRelatedItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchRelatedItemsIterable(ConnectCasesClient client, SearchRelatedItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchRelatedItemsResponseFetcher();
    }

    public Iterator<SearchRelatedItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchRelatedItemsResponseItem> relatedItems() {
        Function<SearchRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedItems() != null) {
                return response.relatedItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchRelatedItemsResponseFetcher
    implements SyncPageFetcher<SearchRelatedItemsResponse> {
        private SearchRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(SearchRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchRelatedItemsResponse nextPage(SearchRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return SearchRelatedItemsIterable.this.client.searchRelatedItems(SearchRelatedItemsIterable.this.firstRequest);
            }
            return SearchRelatedItemsIterable.this.client.searchRelatedItems((SearchRelatedItemsRequest)((Object)SearchRelatedItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

