/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcases.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcases.ConnectCasesAsyncClient;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsRequest;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponse;
import software.amazon.awssdk.services.connectcases.model.SearchRelatedItemsResponseItem;

public class SearchRelatedItemsPublisher
implements SdkPublisher<SearchRelatedItemsResponse> {
    private final ConnectCasesAsyncClient client;
    private final SearchRelatedItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchRelatedItemsPublisher(ConnectCasesAsyncClient client, SearchRelatedItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchRelatedItemsPublisher(ConnectCasesAsyncClient client, SearchRelatedItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchRelatedItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchRelatedItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SearchRelatedItemsResponseItem> relatedItems() {
        Function<SearchRelatedItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.relatedItems() != null) {
                return response.relatedItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchRelatedItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchRelatedItemsResponseFetcher
    implements AsyncPageFetcher<SearchRelatedItemsResponse> {
        private SearchRelatedItemsResponseFetcher() {
        }

        public boolean hasNextPage(SearchRelatedItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchRelatedItemsResponse> nextPage(SearchRelatedItemsResponse previousPage) {
            if (previousPage == null) {
                return SearchRelatedItemsPublisher.this.client.searchRelatedItems(SearchRelatedItemsPublisher.this.firstRequest);
            }
            return SearchRelatedItemsPublisher.this.client.searchRelatedItems((SearchRelatedItemsRequest)((Object)SearchRelatedItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

