/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcampaignsv2.ConnectCampaignsV2AsyncClient;
import software.amazon.awssdk.services.connectcampaignsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcampaignsv2.model.IntegrationSummary;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse;

public class ListConnectInstanceIntegrationsPublisher
implements SdkPublisher<ListConnectInstanceIntegrationsResponse> {
    private final ConnectCampaignsV2AsyncClient client;
    private final ListConnectInstanceIntegrationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConnectInstanceIntegrationsPublisher(ConnectCampaignsV2AsyncClient client, ListConnectInstanceIntegrationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConnectInstanceIntegrationsPublisher(ConnectCampaignsV2AsyncClient client, ListConnectInstanceIntegrationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConnectInstanceIntegrationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConnectInstanceIntegrationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IntegrationSummary> integrationSummaryList() {
        Function<ListConnectInstanceIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.integrationSummaryList() != null) {
                return response.integrationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConnectInstanceIntegrationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConnectInstanceIntegrationsResponseFetcher
    implements AsyncPageFetcher<ListConnectInstanceIntegrationsResponse> {
        private ListConnectInstanceIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectInstanceIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConnectInstanceIntegrationsResponse> nextPage(ListConnectInstanceIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectInstanceIntegrationsPublisher.this.client.listConnectInstanceIntegrations(ListConnectInstanceIntegrationsPublisher.this.firstRequest);
            }
            return ListConnectInstanceIntegrationsPublisher.this.client.listConnectInstanceIntegrations((ListConnectInstanceIntegrationsRequest)((Object)ListConnectInstanceIntegrationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

