/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.connectcampaignsv2.ConnectCampaignsV2Client;
import software.amazon.awssdk.services.connectcampaignsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.connectcampaignsv2.model.IntegrationSummary;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsRequest;
import software.amazon.awssdk.services.connectcampaignsv2.model.ListConnectInstanceIntegrationsResponse;

public class ListConnectInstanceIntegrationsIterable
implements SdkIterable<ListConnectInstanceIntegrationsResponse> {
    private final ConnectCampaignsV2Client client;
    private final ListConnectInstanceIntegrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectInstanceIntegrationsIterable(ConnectCampaignsV2Client client, ListConnectInstanceIntegrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectInstanceIntegrationsResponseFetcher();
    }

    public Iterator<ListConnectInstanceIntegrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IntegrationSummary> integrationSummaryList() {
        Function<ListConnectInstanceIntegrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.integrationSummaryList() != null) {
                return response.integrationSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectInstanceIntegrationsResponseFetcher
    implements SyncPageFetcher<ListConnectInstanceIntegrationsResponse> {
        private ListConnectInstanceIntegrationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectInstanceIntegrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectInstanceIntegrationsResponse nextPage(ListConnectInstanceIntegrationsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectInstanceIntegrationsIterable.this.client.listConnectInstanceIntegrations(ListConnectInstanceIntegrationsIterable.this.firstRequest);
            }
            return ListConnectInstanceIntegrationsIterable.this.client.listConnectInstanceIntegrations((ListConnectInstanceIntegrationsRequest)((Object)ListConnectInstanceIntegrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

