/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaignsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.connectcampaignsv2.model.GetCampaignStateBatchFailureCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FailedCampaignStateResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FailedCampaignStateResponse> {
    private static final SdkField<String> CAMPAIGN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("campaignId").getter(FailedCampaignStateResponse.getter(FailedCampaignStateResponse::campaignId)).setter(FailedCampaignStateResponse.setter(Builder::campaignId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("campaignId").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(FailedCampaignStateResponse.getter(FailedCampaignStateResponse::failureCodeAsString)).setter(FailedCampaignStateResponse.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_ID_FIELD, FAILURE_CODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("campaignId", CAMPAIGN_ID_FIELD);
            this.put("failureCode", FAILURE_CODE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String campaignId;
    private final String failureCode;

    private FailedCampaignStateResponse(BuilderImpl builder) {
        this.campaignId = builder.campaignId;
        this.failureCode = builder.failureCode;
    }

    public final String campaignId() {
        return this.campaignId;
    }

    public final GetCampaignStateBatchFailureCode failureCode() {
        return GetCampaignStateBatchFailureCode.fromValue(this.failureCode);
    }

    public final String failureCodeAsString() {
        return this.failureCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.campaignId());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedCampaignStateResponse)) {
            return false;
        }
        FailedCampaignStateResponse other = (FailedCampaignStateResponse)obj;
        return Objects.equals(this.campaignId(), other.campaignId()) && Objects.equals(this.failureCodeAsString(), other.failureCodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FailedCampaignStateResponse").add("CampaignId", (Object)this.campaignId()).add("FailureCode", (Object)this.failureCodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "campaignId": {
                return Optional.ofNullable(clazz.cast(this.campaignId()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FailedCampaignStateResponse, T> g) {
        return obj -> g.apply((FailedCampaignStateResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String campaignId;
        private String failureCode;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedCampaignStateResponse model) {
            this.campaignId(model.campaignId);
            this.failureCode(model.failureCode);
        }

        public final String getCampaignId() {
            return this.campaignId;
        }

        public final void setCampaignId(String campaignId) {
            this.campaignId = campaignId;
        }

        @Override
        public final Builder campaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        @Override
        public final Builder failureCode(GetCampaignStateBatchFailureCode failureCode) {
            this.failureCode(failureCode == null ? null : failureCode.toString());
            return this;
        }

        public FailedCampaignStateResponse build() {
            return new FailedCampaignStateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FailedCampaignStateResponse> {
        public Builder campaignId(String var1);

        public Builder failureCode(String var1);

        public Builder failureCode(GetCampaignStateBatchFailureCode var1);
    }
}

