/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Agentless Dialer config
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AgentlessDialerConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AgentlessDialerConfig.Builder, AgentlessDialerConfig> {
    private static final SdkField<Double> DIALING_CAPACITY_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("dialingCapacity").getter(getter(AgentlessDialerConfig::dialingCapacity))
            .setter(setter(Builder::dialingCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialingCapacity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALING_CAPACITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Double dialingCapacity;

    private AgentlessDialerConfig(BuilderImpl builder) {
        this.dialingCapacity = builder.dialingCapacity;
    }

    /**
     * Returns the value of the DialingCapacity property for this object.
     * 
     * @return The value of the DialingCapacity property for this object.
     */
    public final Double dialingCapacity() {
        return dialingCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dialingCapacity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentlessDialerConfig)) {
            return false;
        }
        AgentlessDialerConfig other = (AgentlessDialerConfig) obj;
        return Objects.equals(dialingCapacity(), other.dialingCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AgentlessDialerConfig").add("DialingCapacity", dialingCapacity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dialingCapacity":
            return Optional.ofNullable(clazz.cast(dialingCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dialingCapacity", DIALING_CAPACITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AgentlessDialerConfig, T> g) {
        return obj -> g.apply((AgentlessDialerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AgentlessDialerConfig> {
        /**
         * Sets the value of the DialingCapacity property for this object.
         *
         * @param dialingCapacity
         *        The new value for the DialingCapacity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialingCapacity(Double dialingCapacity);
    }

    static final class BuilderImpl implements Builder {
        private Double dialingCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentlessDialerConfig model) {
            dialingCapacity(model.dialingCapacity);
        }

        public final Double getDialingCapacity() {
            return dialingCapacity;
        }

        public final void setDialingCapacity(Double dialingCapacity) {
            this.dialingCapacity = dialingCapacity;
        }

        @Override
        public final Builder dialingCapacity(Double dialingCapacity) {
            this.dialingCapacity = dialingCapacity;
            return this;
        }

        @Override
        public AgentlessDialerConfig build() {
            return new AgentlessDialerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
