/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.connectcampaigns.model.ConnectCampaignsResponse;
import software.amazon.awssdk.services.connectcampaigns.model.FailedCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaigns.model.FailedCampaignStateResponseListCopier;
import software.amazon.awssdk.services.connectcampaigns.model.SuccessfulCampaignStateResponse;
import software.amazon.awssdk.services.connectcampaigns.model.SuccessfulCampaignStateResponseListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCampaignStateBatchResponse
extends ConnectCampaignsResponse
implements ToCopyableBuilder<Builder, GetCampaignStateBatchResponse> {
    private static final SdkField<List<SuccessfulCampaignStateResponse>> SUCCESSFUL_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successfulRequests").getter(GetCampaignStateBatchResponse.getter(GetCampaignStateBatchResponse::successfulRequests)).setter(GetCampaignStateBatchResponse.setter(Builder::successfulRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuccessfulCampaignStateResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FailedCampaignStateResponse>> FAILED_REQUESTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedRequests").getter(GetCampaignStateBatchResponse.getter(GetCampaignStateBatchResponse::failedRequests)).setter(GetCampaignStateBatchResponse.setter(Builder::failedRequests)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedRequests").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FailedCampaignStateResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_REQUESTS_FIELD, FAILED_REQUESTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCampaignStateBatchResponse.memberNameToFieldInitializer();
    private final List<SuccessfulCampaignStateResponse> successfulRequests;
    private final List<FailedCampaignStateResponse> failedRequests;

    private GetCampaignStateBatchResponse(BuilderImpl builder) {
        super(builder);
        this.successfulRequests = builder.successfulRequests;
        this.failedRequests = builder.failedRequests;
    }

    public final boolean hasSuccessfulRequests() {
        return this.successfulRequests != null && !(this.successfulRequests instanceof SdkAutoConstructList);
    }

    public final List<SuccessfulCampaignStateResponse> successfulRequests() {
        return this.successfulRequests;
    }

    public final boolean hasFailedRequests() {
        return this.failedRequests != null && !(this.failedRequests instanceof SdkAutoConstructList);
    }

    public final List<FailedCampaignStateResponse> failedRequests() {
        return this.failedRequests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulRequests() ? this.successfulRequests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedRequests() ? this.failedRequests() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCampaignStateBatchResponse)) {
            return false;
        }
        GetCampaignStateBatchResponse other = (GetCampaignStateBatchResponse)((Object)obj);
        return this.hasSuccessfulRequests() == other.hasSuccessfulRequests() && Objects.equals(this.successfulRequests(), other.successfulRequests()) && this.hasFailedRequests() == other.hasFailedRequests() && Objects.equals(this.failedRequests(), other.failedRequests());
    }

    public final String toString() {
        return ToString.builder((String)"GetCampaignStateBatchResponse").add("SuccessfulRequests", this.hasSuccessfulRequests() ? this.successfulRequests() : null).add("FailedRequests", this.hasFailedRequests() ? this.failedRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulRequests": {
                return Optional.ofNullable(clazz.cast(this.successfulRequests()));
            }
            case "failedRequests": {
                return Optional.ofNullable(clazz.cast(this.failedRequests()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("successfulRequests", SUCCESSFUL_REQUESTS_FIELD);
        map.put("failedRequests", FAILED_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCampaignStateBatchResponse, T> g) {
        return obj -> g.apply((GetCampaignStateBatchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ConnectCampaignsResponse.BuilderImpl
    implements Builder {
        private List<SuccessfulCampaignStateResponse> successfulRequests = DefaultSdkAutoConstructList.getInstance();
        private List<FailedCampaignStateResponse> failedRequests = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCampaignStateBatchResponse model) {
            super(model);
            this.successfulRequests(model.successfulRequests);
            this.failedRequests(model.failedRequests);
        }

        public final List<SuccessfulCampaignStateResponse.Builder> getSuccessfulRequests() {
            List<SuccessfulCampaignStateResponse.Builder> result = SuccessfulCampaignStateResponseListCopier.copyToBuilder(this.successfulRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessfulRequests(Collection<SuccessfulCampaignStateResponse.BuilderImpl> successfulRequests) {
            this.successfulRequests = SuccessfulCampaignStateResponseListCopier.copyFromBuilder(successfulRequests);
        }

        @Override
        public final Builder successfulRequests(Collection<SuccessfulCampaignStateResponse> successfulRequests) {
            this.successfulRequests = SuccessfulCampaignStateResponseListCopier.copy(successfulRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequests(SuccessfulCampaignStateResponse ... successfulRequests) {
            this.successfulRequests(Arrays.asList(successfulRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulRequests(Consumer<SuccessfulCampaignStateResponse.Builder> ... successfulRequests) {
            this.successfulRequests(Stream.of(successfulRequests).map(c -> (SuccessfulCampaignStateResponse)((SuccessfulCampaignStateResponse.Builder)SuccessfulCampaignStateResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FailedCampaignStateResponse.Builder> getFailedRequests() {
            List<FailedCampaignStateResponse.Builder> result = FailedCampaignStateResponseListCopier.copyToBuilder(this.failedRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedRequests(Collection<FailedCampaignStateResponse.BuilderImpl> failedRequests) {
            this.failedRequests = FailedCampaignStateResponseListCopier.copyFromBuilder(failedRequests);
        }

        @Override
        public final Builder failedRequests(Collection<FailedCampaignStateResponse> failedRequests) {
            this.failedRequests = FailedCampaignStateResponseListCopier.copy(failedRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(FailedCampaignStateResponse ... failedRequests) {
            this.failedRequests(Arrays.asList(failedRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedRequests(Consumer<FailedCampaignStateResponse.Builder> ... failedRequests) {
            this.failedRequests(Stream.of(failedRequests).map(c -> (FailedCampaignStateResponse)((FailedCampaignStateResponse.Builder)FailedCampaignStateResponse.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCampaignStateBatchResponse build() {
            return new GetCampaignStateBatchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ConnectCampaignsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCampaignStateBatchResponse> {
        public Builder successfulRequests(Collection<SuccessfulCampaignStateResponse> var1);

        public Builder successfulRequests(SuccessfulCampaignStateResponse ... var1);

        public Builder successfulRequests(Consumer<SuccessfulCampaignStateResponse.Builder> ... var1);

        public Builder failedRequests(Collection<FailedCampaignStateResponse> var1);

        public Builder failedRequests(FailedCampaignStateResponse ... var1);

        public Builder failedRequests(Consumer<FailedCampaignStateResponse.Builder> ... var1);
    }
}

