/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.connectcampaigns.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * UpdateCampaignDialerConfigRequest
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCampaignDialerConfigRequest extends ConnectCampaignsRequest implements
        ToCopyableBuilder<UpdateCampaignDialerConfigRequest.Builder, UpdateCampaignDialerConfigRequest> {
    private static final SdkField<DialerConfig> DIALER_CONFIG_FIELD = SdkField.<DialerConfig> builder(MarshallingType.SDK_POJO)
            .memberName("dialerConfig").getter(getter(UpdateCampaignDialerConfigRequest::dialerConfig))
            .setter(setter(Builder::dialerConfig)).constructor(DialerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialerConfig").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateCampaignDialerConfigRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(DIALER_CONFIG_FIELD, ID_FIELD));

    private final DialerConfig dialerConfig;

    private final String id;

    private UpdateCampaignDialerConfigRequest(BuilderImpl builder) {
        super(builder);
        this.dialerConfig = builder.dialerConfig;
        this.id = builder.id;
    }

    /**
     * Returns the value of the DialerConfig property for this object.
     * 
     * @return The value of the DialerConfig property for this object.
     */
    public final DialerConfig dialerConfig() {
        return dialerConfig;
    }

    /**
     * Returns the value of the Id property for this object.
     * 
     * @return The value of the Id property for this object.
     */
    public final String id() {
        return id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dialerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCampaignDialerConfigRequest)) {
            return false;
        }
        UpdateCampaignDialerConfigRequest other = (UpdateCampaignDialerConfigRequest) obj;
        return Objects.equals(dialerConfig(), other.dialerConfig()) && Objects.equals(id(), other.id());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCampaignDialerConfigRequest").add("DialerConfig", dialerConfig()).add("Id", id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dialerConfig":
            return Optional.ofNullable(clazz.cast(dialerConfig()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCampaignDialerConfigRequest, T> g) {
        return obj -> g.apply((UpdateCampaignDialerConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ConnectCampaignsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCampaignDialerConfigRequest> {
        /**
         * Sets the value of the DialerConfig property for this object.
         *
         * @param dialerConfig
         *        The new value for the DialerConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialerConfig(DialerConfig dialerConfig);

        /**
         * Sets the value of the DialerConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DialerConfig.Builder} avoiding the need
         * to create one manually via {@link DialerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #dialerConfig(DialerConfig)}.
         * 
         * @param dialerConfig
         *        a consumer that will call methods on {@link DialerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialerConfig(DialerConfig)
         */
        default Builder dialerConfig(Consumer<DialerConfig.Builder> dialerConfig) {
            return dialerConfig(DialerConfig.builder().applyMutation(dialerConfig).build());
        }

        /**
         * Sets the value of the Id property for this object.
         *
         * @param id
         *        The new value for the Id property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ConnectCampaignsRequest.BuilderImpl implements Builder {
        private DialerConfig dialerConfig;

        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCampaignDialerConfigRequest model) {
            super(model);
            dialerConfig(model.dialerConfig);
            id(model.id);
        }

        public final DialerConfig.Builder getDialerConfig() {
            return dialerConfig != null ? dialerConfig.toBuilder() : null;
        }

        public final void setDialerConfig(DialerConfig.BuilderImpl dialerConfig) {
            this.dialerConfig = dialerConfig != null ? dialerConfig.build() : null;
        }

        @Override
        public final Builder dialerConfig(DialerConfig dialerConfig) {
            this.dialerConfig = dialerConfig;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCampaignDialerConfigRequest build() {
            return new UpdateCampaignDialerConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
